import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import AmosWebSocket from 'amos-websocket';
import { Connect } from 'amos-framework';
import { getRiskRiseUprateAction } from './../../../../services/situationService';
import SysWsURL, { completeToken } from './../../../../consts/wsUrlConsts';

const eventConnect = Connect.eventConnect;

/**
 * 巡检点统计
 * @class MonthlyInspection
 * @extends {Component}
 */
class RiskDegreePie extends Component {
  constructor(props) {
    super(props);
    this.state = {
      monthData: { type0Rate: '0%', countOfType0: 0 },
      seasonData: { type0Rate: '0%', countOfType0: 0 },
      yearData: { type0Rate: '0%', countOfType0: 0 }
    };
  }

  componentWillMount() {
    this.getRiskRiseUprate();
  }

  getRiskRiseUprate() {
    getRiskRiseUprateAction().then(
      data => {
        let { monthData, seasonData, yearData } = this.state;
        monthData = data.month;
        seasonData = data.season;
        yearData = data.year;
        this.setState({
          monthData,
          seasonData,
          yearData
        });
      }
    );
  }

  getMonthOptions(value, obj) {
    let data = [];
    let color = 'lightgray';
    let data1 = {};
    let data2 = {};
    if (obj) {
      if (value === 'month') {
        data1.name = obj.type0Rate + '\r\n' + '本月风险' + '\r\n' + '上升率';
        color = '#3aa0fe';
      } else if (value === 'season') {
        data1.name = obj.type0Rate + '\r\n' + '本季度风险' + '\r\n' + '上升率';
        color = '#68d288';
      } else if (value === 'year') {
        data1.name = obj.type0Rate + '\r\n' + '本年风险' + '\r\n' + '上升率';
        color = '#fad955';
      }
      data1.value = obj.countOfType0;
      data2.value = obj.countOfSource - obj.countOfType0;
      data2.name = '';
      data.push(data1);
      data.push(data2);
    }
    let colors = [];
    colors.push(color);
    colors.push('lightgray');
    return {
      // tooltip: {
      //   align: 'center',
      //   trigger: 'item',
      //   formatter: '{a} <br/>{b}: {c} ({d}%)'
      // },
      color: colors,
      series: [
        {
          name: '风险率',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: 'black',
              position: 'center',
              formatter: '{b}'
            }//,
            // emphasis: {
            //   show: true,
            //   textStyle: {
            //     fontSize: '20',
            //     fontWeight: 'bold'
            //   }
            // }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
          // data: [
          //   { value: 335, name: '直接访问' },
          //   { value: 1548, name: '搜索引擎' }
          // ]
        }
      ]
    };
  }

  getSeasonOptions(value, obj) {
    let data = [];
    let color = 'lightgray';
    let data1 = {};
    let data2 = {};
    if (obj) {
      if (value === 'month') {
        data1.name = obj.type0Rate + '\r\n' + '本月风险' + '\r\n' + '上升率';
        color = '#3aa0fe';
      } else if (value === 'season') {
        data1.name = obj.type0Rate + '\r\n' + '本季度风险' + '\r\n' + '上升率';
        color = '#68d288';
      } else if (value === 'year') {
        data1.name = obj.type0Rate + '\r\n' + '本年风险' + '\r\n' + '上升率';
        color = '#fad955';
      }
      data1.value = obj.countOfType0;
      data2.value = obj.countOfSource - obj.countOfType0;
      data2.name = '';
      data.push(data1);
      data.push(data2);
    }
    let colors = [];
    colors.push(color);
    colors.push('lightgray');
    return {
      // tooltip: {
      //   align: 'center',
      //   trigger: 'item',
      //   formatter: '{a} <br/>{b}: {c} ({d}%)'
      // },
      color: colors,
      series: [
        {
          name: '风险率',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: 'black',
              position: 'center',
              formatter: '{b}'
            }//,
            // emphasis: {
            //   show: true,
            //   textStyle: {
            //     fontSize: '20',
            //     fontWeight: 'bold'
            //   }
            // }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
          // data: [
          //   { value: 335, name: '直接访问' },
          //   { value: 1548, name: '搜索引擎' }
          // ]
        }
      ]
    };
  }

  getYearOptions(value, obj) {
    let data = [];
    let color = 'lightgray';
    let data1 = {};
    let data2 = {};
    if (obj) {
      if (value === 'month') {
        data1.name = obj.type0Rate + '\r\n' + '本月风险' + '\r\n' + '上升率';
        color = '#3aa0fe';
      } else if (value === 'season') {
        data1.name = obj.type0Rate + '\r\n' + '本季度风险' + '\r\n' + '上升率';
        color = '#68d288';
      } else if (value === 'year') {
        data1.name = obj.type0Rate + '\r\n' + '本年风险' + '\r\n' + '上升率';
        color = '#fad955';
      }
      data1.value = obj.countOfType0;
      data2.value = obj.countOfSource - obj.countOfType0;
      data2.name = '';
      data.push(data1);
      data.push(data2);
    }
    let colors = [];
    colors.push(color);
    colors.push('lightgray');
    return {
      // tooltip: {
      //   align: 'center',
      //   trigger: 'item',
      //   formatter: '{a} <br/>{b}: {c} ({d}%)'
      // },
      color: colors,
      series: [
        {
          name: '风险率',
          type: 'pie',
          radius: ['50%', '70%'],
          avoidLabelOverlap: false,
          label: {
            normal: {
              show: true,
              color: 'black',
              position: 'center',
              formatter: '{b}'
            }//,
            // emphasis: {
            //   show: true,
            //   textStyle: {
            //     fontSize: '20',
            //     fontWeight: 'bold'
            //   }
            // }
          },
          labelLine: {
            normal: {
              show: false
            }
          },
          data
          // data: [
          //   { value: 335, name: '直接访问' },
          //   { value: 1548, name: '搜索引擎' }
          // ]
        }
      ]
    };
  }

  handleData = () => {
    this.getRiskRiseUprate();
  }

  render() {
    let { monthData, seasonData, yearData } = this.state;
    const wsURL = completeToken(SysWsURL.rulews);
    let monthOption = this.getMonthOptions('month', monthData);
    let seasonOption = this.getSeasonOptions('season', seasonData);
    let yearOption = this.getYearOptions('year', yearData);
    return (
      <div className="risk-degree-pie">
        <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />
        <div className="risk-degree-pie1">
          <AmosEcharts option={monthOption} />
          <span>本月风险上升率 |  {monthData.type0Rate}   {monthData.countOfType0}个</span>
        </div>
        <div className="risk-degree-pie2">
          <AmosEcharts option={seasonOption} />
          <span>本季度风险上升率 |  {seasonData.type0Rate}   {seasonData.countOfType0}个</span>
        </div>
        <div className="risk-degree-pie3">
          <AmosEcharts option={yearOption} />
          <span>本年风险上升率 |  {yearData.type0Rate}   {yearData.countOfType0}个</span>
        </div>
      </div>
    );
  }
}

RiskDegreePie.propTypes = {};

RiskDegreePie.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default RiskDegreePie;
