import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Layout } from 'amos-framework';
import RiskDegreePie from './RiskDegreePie';
import RiskDegreeHistogram from './RiskDegreeHistogram';
import IncidenceSeverityMatrix from './IncidenceSeverityMatrix';
import SituationMap from './SituationMap';

const { Header, Content, Sider } = Layout;

/**
 * 风险评估
 */
class RiskAssessment extends Component {

  render() {
    return (
      <div className="risk-assessment-view" style={{ width: '100%', height: '100%' }}>
        <Layout>
          <Layout>
            <Header>
              <div className="risk-assessment-view-situation">厂区风险态势图</div>
              <div style={{ margin: '20px' }}>
                <SituationMap />
              </div>
            </Header>
            <Content>
              <Layout className="risk-assessment-view-content">
                <Sider>
                  <div className="risk-assessment-view-situation">风险度(RPN)上升百分比</div>
                  <RiskDegreePie />
                </Sider>
                <Content className='risk-assessment-view-situation-matrix' >
                  <div className="risk-assessment-view-situation">发生率/严重度矩阵</div>
                  <IncidenceSeverityMatrix />
                </Content>
              </Layout>
            </Content>
          </Layout>
          <Sider className='risk-assessment-view-situation-histogram' >
            <div className="risk-assessment-view-situation">风险度(RPN) TOP10</div>
            <RiskDegreeHistogram />
          </Sider>
        </Layout>
      </div>
    );
  }
}

RiskAssessment.propTypes = {

};
export default RiskAssessment;
