import React, { Component } from 'react';
import PropTypes from 'prop-types';
import AmosEcharts from 'amos-viz/lib/echarts';
import BarOptions from 'amos-viz/lib/echarts/options/bar';
import { fetchPointStatistics } from './../../../services/checkInfoService';

/**
 * 当前隐患治理情况
 * @class CurDangerCount
 * @extends {Component}
 */
class CurDangerCount extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {}

  getOptions(dataList) {
    return {
      color: ['#FF0000', '#04cede'],//color: ['#FF0000', '#00FFFF'],
      series: [
        {
          name: '隐患分布',
          type: 'pie',
          silent: true,
          radius: ['45%', '65%'],
          itemStyle: {
            normal: {
              label: {
                show: true,
                position: 'center',
                formatter: function(params) {
                  let name = params.name;
                  if (name === '处理中') {
                    return '{a|' + params.value + '}' + '\r\n' + '{a|' + params.name + '}';
                  } else {
                    return '';
                  }
                },
                rich: {
                  a: {
                    fontSize: '20',
                    color: 'black' //'#ffffff'
                  }
                }
              },
              labelLine: {
                show: false
              },
              textStyle: {
                fontSize: 25,
                fontWeight: 'bold'
              }
            },
            emphasis: {
              label: {
                show: true,
                position: 'inner',
                formatter: '{b}\n {c}({d}%)',
                textStyle: {
                  fontSize: '25',
                  fontWeight: 'bold'
                }
              }
            }
          },
          data: dataList
        }
      ]
    };
  }

  render() {
    let data = this.props.curData;
    const option = this.getOptions(data);
    let timeOut = 0;
    data &&
      data.map(e => {
        if (e.name === '已超时') {
          timeOut = e.value;
        }
      });
    return (
      <div className="point-statistics">
        <div className="point-statistics-title">当前隐患治理情况</div>
        <AmosEcharts option={option} />
        <div className="point-statistics-concent">
          已超时：<span>{timeOut}</span>
        </div>
      </div>
    );
  }
}

CurDangerCount.propTypes = {};

CurDangerCount.defaultProps = {
  data: {},
  legend: [],
  chartStyle: { width: '100%', height: '20rem' }
};

export default CurDangerCount;
