import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Calendar } from 'amos-antd';
import { Badge } from 'amos-framework';
import moment from 'moment';
import XJCheckSearch from './XJCheckSearch';
import CheckListPanelContent from './CheckListPanelContent';
import { fetchXJCheckInfoAction, fetchPtDetailByIdAction ,fetchCalCountPanelAction} from './../../../services/checkInfoService';
import './../../../styles/view/biz/point/point.scss';
/**
 *
 * @class CheckList
 * @extends {Component}
 */

class CheckList extends Component {
  constructor(props) {
    super(props);
    this.state = {
      searchParam: {},
      statisticsData: [],
      totalCount: 0,
      calParam: {}
    };
  }
  componentDidMount() {}
  componentWillMount() {
    if (this.props.location.state) {
      let { pointID, pointName } = this.props.location.state;
      this.loadPointDetail(pointID); //查询点编号和名称
      this.getCalenderCountPanel(pointID, null); //查询巡检记录日历
    }
  }
  componentWillReceiveProps(nextProps) {
    if (nextProps) {
      if (nextProps.location && nextProps.location.state) {
        let { pd } = this.state;
        let { pointID, pointName } = nextProps.location.state;
        if (pointID !== pd) {
          this.setState({ pd: pointID });
          this.getPointDetail(pointID); //查询点编号和名称
          this.getCalenderCountPanel(pointID, null); //查询巡检记录日历
          this.queryCheckInfoFor3d(pointID); //查询当天巡检记录
        }
      }
    }
  }

  loadPointDetail(pointID) {
    let id = pointID;
    if (id) {
      this.setState({
        pd: id
      });
      this.getPointDetail(id);
    }
  }

  onSelectedChange = (value, type) => {
    let { searchParam, pd } = this.state;
    let { checkTime } = this.state.searchParam; //上次日历日期
    let time = value.format('YYYYMMDD');
    searchParam[type] = time;
    this.setState({ searchParam });
    const param = { type, time };
    this.questStatistiscData(param);
    if (time.substring(0, 6) !== checkTime.substring(0, 6)) {
      //当前选择日期与上次日期不再一个月在进行查询
      this.getCalenderCountPanel(pd, value);
    }
  };

  getPointDetail(id) {
    fetchPtDetailByIdAction(id).then(data => {
      this.setState({
        no: data.pointNo,
        pdName: data.name
      });
    });
  }

  queryCheckInfoFor3d = pd => {
    let params = { pageNumber: 0, pageSize: 10 };
    params.checkTime = moment().format('YYYYMMDD');
    this.queryCheckInfo(pd, params);
  };

  questStatistiscData = param => {
    let { pd, searchParam } = this.state;
    if (searchParam.checkTime === undefined) {
      searchParam.checkTime = moment().format('YYYYMMDD');
    }
    if (param.current != null) {
      //前端的current 即后端的pageNumber
      param.pageNumber = param.current;
    }
    Object.assign(searchParam, { ...param });
    this.queryCheckInfo(pd, searchParam);
  };

  //查询巡检记录
  queryCheckInfo = (pd, searchParam) => {
    fetchXJCheckInfoAction(pd, searchParam).then(data => {
      if (data) {
        let statisticsData = data.content;
        let totalCount = data.totalElements;
        this.setState({
          statisticsData,
          totalCount
        });
      }
    });
  };

  setSearchParam = searchParam => {
    this.setState({ searchParam });
    this.questStatistiscData(searchParam);
  };

  getCalenderCountPanel(pd, date) {
    let countDate = moment().format('YYYYMMDD');
    if (date) {
      countDate = date.format('YYYYMMDD');
    }
    let qryData = {
      pointId: pd,
      date: countDate
    };
    fetchCalCountPanelAction(qryData).then(data => {
      this.setState({ calParam: data });
    });
  }

  dateCellRender(value) {
    let { calParam } = this.state;
    let date = value.format('YYYYMMDD');
    if (Object.keys(calParam).some(e => calParam[e].checkDate === date && calParam[e].num > 0)) {
      return <Badge status="success" />;
    } else {
      return null;
    }
  }

  onPanelChange(date, mode) {
    let { pd } = this.state;
    this.getCalenderCountPanel(pd, date);
  }

  render() {
    let { statisticsData, totalCount, pd, pdName, no } = this.state;
    return (
      <div className="point-view">
        <div className="create-device-root">
          <div className="create-device-host-top">
            <div className="table-title">
              {pdName}({no})
            </div>
            <div className="table-search">
              <XJCheckSearch pointID={pd} setSearchParam={this.setSearchParam} />
            </div>
          </div>
          <div className="create-device-host-bottom">
            <div className="create-device-host-left">
              <Calendar
                fullscreen={false}
                onChange={e => this.onSelectedChange(e, 'checkTime')}
                dateCellRender={value => this.dateCellRender(value)}
                onPanelChange={(date, mode) => this.onPanelChange(date, mode)}
              />
            </div>
            <CheckListPanelContent count={totalCount} fetchData={this.questStatistiscData} dataList={statisticsData} {...this.props} />
          </div>
        </div>
      </div>
    );
  }
}

CheckList.propTypes = {
  outterPageConfig: PropTypes.object
};

export default CheckList;
