import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Modal } from 'amos-antd';
import { browserHistory } from 'amos-react-router';
import dt2react from 'dt2react';
import AmosGridTable from './../common/tableComponent/table/AmosGridTable';
import { pathMapping } from './../../../routes/customRoutes';

// const CheckDetailPath = pathMapping.pointCheckDetail;
const CheckDetailPath = '/biz/patrolpoint/checkdetail';

const xjColumns = (thisClass, actions,changeColour) => {
  return [
    {
      title: '巡检时间',
      dataIndex: 'checkTime',
      key: 'checkTime',
      width: '15%'
    },
    {
      title: '巡检人员',
      dataIndex: 'realName',
      key: 'realName',
      width: '10%'
    },
    {
      title: '部门',
      dataIndex: 'name',
      key: 'name',
      width: '16%'
    },
    {
      title: '联系方式',
      dataIndex: 'loginName',
      key: 'loginName',
      width: '16%'
    },
    {
      title: '巡检状态',
      dataIndex: 'isOK',
      key: 'isOK',
      width: '12%',
      render: text => changeColour(text)
    },
    {
      title: '异常内容',
      dataIndex: 'errorMsg',
      key: 'errorMsg',
      width: '16%',
      render: text => <span style={{ color: '#FF9900' }}>{text}</span>
    },
    {
      title: '任务编号',
      dataIndex: 'errorID',
      key: 'errorID',
      width: '10%'
    }
  ];
};
//偏移110px
const offsetHeight = 110;
const defaultHeight = 450;

/**
 *
 *
 * @class CheckListPanelContent
 * @extends {Component}
 */
class CheckListPanelContent extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: props.outterPageConfig ? props.outterPageConfig.current : 1,
      pageSize: props.outterPageConfig ? props.outterPageConfig.pageSize : 10
    };
    this.state = {
      selectedRows: [],
      selectedRowKeys: [],
      reload() {}
    };
  }

  /**
   * 获取表格所选则的行数据
   */
  getSelectedRows = (selectedRows, selectedRowKeys) => {
    this.setState({ selectedRows, selectedRowKeys });
  };

  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  changeColour = text => {
    if (text === '1') {
      text = <span style={{ color: '#00FFFF' }}>合格</span>;
    } else if (text === '2') {
      text = <span style={{ color: '#FF9900' }}>不合格</span>;
    } else if (text === '3') {
      text = <span>未执行</span>;
    }
    return text;
  };

  deleteMultiDevice = ids => {
    Modal.confirm({
      content: '确定要删除吗？',
      onCancel: () => {},
      onOk: () => {
        this.props.deleteDeviceById(ids);
      }
    });
  };

  getRowClassName = (record, index) => {
    let highlight = this.highlight;
    if (highlight && record.id === highlight) {
      return 'highlight-row';
    } else {
      return 'normal-row';
    }
  };

  setPageConfig = ({ pageSize, current }) => {
    if (pageSize !== undefined) {
      this.pageConfig.pageSize = pageSize;
    }
    if (current !== undefined) {
      this.pageConfig.current = current;
    }
  };

  getPanelHeight = () => {
    let alarmTablePanel = this.alarmTablePanel;
    let tableLocation = dt2react.getOffset(alarmTablePanel) || {};
    return tableLocation !== undefined ? tableLocation.height - offsetHeight : defaultHeight;
  };

  onRowClick = record => {
    console.log(record);
    let { checkID, pointID } = record;
    let path = {
      pathname: CheckDetailPath,
      state: { checkID, pointID }
    };
    browserHistory.push(path);
  };

  render() {
    let { dataList, fetchData, count } = this.props;
    let defaultPageConfig = this.pageConfig;
    const changeColour = this.changeColour;
    const actions = {};

    return (
      <div className="device-list-content">
        <AmosGridTable
          columns={xjColumns(this, actions, changeColour)}
          callBack={this.reload}
          dataList={dataList}
          totals={count}
          getTableDataAction={fetchData}
          getSelectedRows={this.getSelectedRows}
          rowClassName={this.getRowClassName}
          setPageConfig={this.setPageConfig}
          defaultPageConfig={defaultPageConfig}
          getPanelHeight={this.getPanelHeight}
          onRowClick={this.onRowClick}
          isChecked={false}
        />
      </div>
    );
  }
}

CheckListPanelContent.propTypes = {
  dataList: PropTypes.array,
  fetchData: PropTypes.func,
  count: PropTypes.number,
  outterPageConfig: PropTypes.object,
  deleteDeviceById: PropTypes.func
};

export default CheckListPanelContent;
