import React, { Component } from 'react';
import { Table } from 'amos-antd';

const MalfunctionList = [
  {
    rownum: '1',
    severity: '1111',
    alertReason: '1',
    alertIP: '1',
    alertType: '1',
    alertStatus: '1',
    onTime: '1',
    insurePerson: '1',
    birthTime: '1',
    clsTime: '1',
    clsPerson: '1'
  },
  {
    rownum: '2',
    severity: '2222',
    alertReason: '2',
    alertIP: '2',
    alertType: '2',
    alertStatus: '2',
    onTime: '2',
    insurePerson: '2',
    birthTime: '2',
    clsTime: '2',
    clsPerson: '2'
  },
  {
    rownum: '3',
    severity: '3333',
    alertReason: '3',
    alertIP: '3',
    alertType: '3',
    alertStatus: '3',
    onTime: '3',
    insurePerson: '3',
    birthTime: '3',
    clsTime: '3',
    clsPerson: '3'
  },
  {
    rownum: '4',
    severity: '4444',
    alertReason: '4',
    alertIP: '4',
    alertType: '4',
    alertStatus: '4',
    onTime: '4',
    insurePerson: '4',
    birthTime: '4',
    clsTime: '4',
    clsPerson: '4'
  }
];
class Alert extends Component {
  constructor(props) {
    super(props);
    this.state = {
      totalPage: 0,
      total: 0,
      current: 1,
      pageSize: 5
    };
  }

  /**
   *
   *设置共多少页
   */
  showTotal = (total) => {
    return `共 ${( total % this.state.pageSize) ===0 ? Math.floor((total / this.state.pageSize)) : Math.floor((( total / this.state.pageSize) + 1))} 页`;
  }

  /**
   * 设置当前页事件
   */
  onPaginationChange = (current) => {
    this.setState({ current },this.reload);
  }

  rendColumns = () => {
    return [
      {
        title: '序号',
        dataIndex: 'rownum',
        key: 'rownum',
        width: '2%'
      },
      {
        title: '严重度',
        dataIndex: 'severity',
        key: 'severity',
        width: '5%'
      },
      {
        title: '告警原因',
        dataIndex: 'alertReason',
        key: 'alertReason',
        width: '5%'
      },
      {
        title: '告警IP',
        dataIndex: 'alertIP',
        key: 'alertIP',
        width: '5%'
      },
      {
        title: '告警类别',
        dataIndex: 'alertType',
        key: 'alertType',
        width: '5%'
      },
      {
        title: '告警状态',
        dataIndex: 'alertStatus',
        key: 'alertStatus',
        width: '5%'
      },
      {
        title: '产生时间',
        dataIndex: 'birthTime',
        key: 'birthTime',
        width: '5%'
      },
      {
        title: '持续时间',
        dataIndex: 'onTime',
        key: 'onTime',
        width: '5%'
      },
      {
        title: '确认人',
        dataIndex: 'insurePerson',
        key: 'insurePerson',
        width: '5%'
      },
      {
        title: '清除时间',
        dataIndex: 'clsTime',
        key: 'clsTime',
        width: '5%'
      },
      {
        title: '清除人',
        dataIndex: 'clsPerson',
        key: 'clsPerson',
        width: '5%'
      }
    ];
  };
  render() {
    let tepmPage = Object.assign({
      size: 'small',
      total: this.state.totals,
      current: this.state.current,
      pageSize: this.state.pageSize,
      //onShowSizeChange: this.onSizeChange,
      onChange: this.onPaginationChange,
      showSizeChanger: 'true',
      pageSizeOptions: [5],
      showTotal: this.showTotal
    },  true);
    return (
      <div style={{width: '78%',height: '100%',marginLeft: '28px'}}>
        <Table
          pagination={tepmPage}
          columns={this.rendColumns()}
          dataSource={MalfunctionList} />
      </div>
    );
  }
}

export default Alert;
