import loadScripts from 'dt2react/lib/utils/loadScripts';
import loader from 'amos-3d/lib/_utils/loader';
import dynamicLoader from 'amos-3d/lib/_utils/dynamicLoader';

export const isDev = process.env.NODE_ENV !== 'production';

export const removeScripts = (scripts, includes = []) => {
  for (let i = 0; i < scripts.length; i++) {
    const script = scripts[i];
    if (script && script.src) {
      if (includes.some(key => script.src.indexOf(key) > 0)) {
        script.parentNode.removeChild(script);
      }
    }
  }
};

export const cesiumScripts = {
  key: 'cesiumscripts',
  url: isDev ? '/node_modules/cesium/Build/Cesium/Cesium.js' : '/third/cesium/Cesium.js'
};

export const cesiumStyles = {
  key: 'cesiumstyles',
  url: isDev ? '/node_modules/cesium/Build/Cesium/Widgets/widgets.css' : '/third/cesium/Widgets/widgets.css'
};

export const getEquipDescr = (params = {}) => {
  const equip = `
  <table border="1" width="100%">
    <tr>
      <td width="50%" align="right">设备</td>
      <td>${params.equipname}</td>
    </tr>
    <tr>
      <td width="50%" align="right">设备位号</td>
      <td>${params.equippositionnum}</td>
    </tr>
    <tr>
      <td width="50%" align="right">所在分区</td>
      <td>${params.area}</td>
    </tr>
    <tr>
      <td width="50%" align="right">所在车间</td>
      <td>${params.dept}</td>
    </tr>
    <tr>
      <td width="50%" align="right">所在工段</td>
      <td>${params.section}</td>
    </tr>
    <tr>
      <td width="50%" align="right">备注</td>
      <td>${params.remark}</td>
    </tr>
  </table>`;
  return equip;
};

export const getRiskDescr = (params = {}) => {
  const risk = `
  <table border="1" width="100%">
    <tr>
      <td width="50%" align="right">风险点名称</td>
      <td>${params.riskpointname}</td>
    </tr>
    <tr>
      <td width="50%" align="right">风险点ID</td>
      <td>${params.riskpositioninfoid}</td>
    </tr>
    <tr>
      <td width="50%" align="right">设备位号</td>
      <td>${params.equippositionnum}</td>
    </tr>
    <tr>
      <td width="50%" align="right">固有风险等级</td>
      <td>${params.riskLevel}</td>
    </tr>
    <tr>
      <td width="50%" align="right">实时风险等级</td>
      <td>${params.by1}</td>
    </tr>
    <tr>
      <td width="50%" align="right">备注</td>
      <td>${params.remark}</td>
    </tr>
  </table>`;

  return risk;
};

export const getVideoDescr = (params = {}) => {
  const video = `
  <table border="1" width="100%">
    <tr>
      <td width="50%" align="right">视频ID</td>
      <td>${params.videomonitorinfoid}</td>
    </tr>
    <tr>
      <td width="50%" align="right">视频</td>
      <td><a href="Webshell00:where='params.videomonitorinfoid'" style="font-size:16px;">视频链接</a>
      </td>
    </tr>
    <tr>
      <td width="50%" align="right">装备ID</td>
      <td>${params.equippositioninfoid}</td>
    </tr>
    <tr>
      <td width="50%" align="right">摄像机名称</td>
      <td>${params.cameraname}</td>
    </tr>
    <tr>
      <td width="50%" align="right">摄像机IP</td>
      <td>${params.cameraip}</td>
    </tr>
    <tr>
      <td width="50%" align="right">备注</td>
      <td>${params.remark}</td>
    </tr>
  </table>`;

  return video;
};

export const getGlobalConf = () => {
  const config = window.tileConfig || {};
  return config;
};

export const text2Speech = (obj) => {
  if ('speechSynthesis' in window) {
    let { content } = obj;
    let sentence = new SpeechSynthesisUtterance(content);
    let voices = window.speechSynthesis.getVoices();
    for (let i = 0; i < voices.length; i++) {
      if (voices[i]['name'] === 'Alex') {
        sentence.voice = voices[i];
      }
    }
    sentence.pitch = 1;
    sentence.rate = 1.5;//速度
    sentence.text = content;
    window.speechSynthesis.speak(sentence);
    // window.speechSynthesis.speak(new SpeechSynthesisUtterance("我是要朗读的语音？"));
  } else {
    console.log('当前浏览器不支持语音朗读.');
  }
};

export const riskFlashing = (instance) => {
  instance.gis3DRenderer.createMaker();
};

export { loadScripts, loader, dynamicLoader };
