import { utils } from 'amos-tool';
import { Toast, Paragraph } from 'amos-framework';

export const controlItemClickType = {
  cancel: 'cancel',
  init: 'init'
};

export const markerTypeMapping = {
  risk: {
    blue: 0,
    normal: 1,
    miss: 2,
    warning: 3,
    alarm: 4
  }
};

/**
 * 手动操作类型
 */
export const operateTypes = {
  // 操作或者选中线路
  LINK: 'link',
  POINT: 'point',
  // marker 点数据源变化
  POINT_CHANGE: 'point_change',
  // 批量 marker 点数据源变化
  BATCH_POINT_CHANGE: 'batch_point_change',

  POINT_SEARCH: 'search'
};

export const pointTopicMapping = {
  riskSource: 'riskSource-point',
  risk: 'risk-point',
  taskWork: 'taskWork'
};

export const eventTopics = {
  // 双屏通信主题
  transtopic: 'transtopic',

  baseTile: 'baseTile',
  baseTile_view: 'baseTile.view',

  level_filter_risk: 'baseTile.view.level_filter_risk', // 风险点 级别过滤
  manual_operate: 'baseTile.view.manual_operate', // 手动操作
  point_change: 'baseTile.view.point_change', // marker 点变化
  batch_point_change: 'baseTile.view.batch_point_change', // 批量 marker 点变化
  linkdata_change: 'baseTile.view.linkdata_change', // marker 点变化

  point_patrol: 'baseTile.view.point_patrol', // 巡检点
  point_risk: 'baseTile.view.point_risk', // 风险点
  point_video: 'baseTile.view.point_video', // 视频点
  point_person: 'baseTile.view.point_person', // 人员点
  point_data: 'baseTile.view.point_data', // 数据点
  point_croom: 'baseTile.view.point_croom', // 控制室
  point_trajectory: 'baseTile.view.point_trajectory', // 轨迹

  innate_layer: 'baseTile.view.controller_layer', // 楼层操作
  innate_operater: 'baseTile.view.controller_operater', // 三维内置操作

  fromws: 'baseTile.fromws',

  datapane_msg: 'baseTile.fromws.datapane_msg', // datapane 消息

  broad_msg: 'baseTile.fromws.broad_msg', // 播报消息

  global_msg: 'baseTile.fromws.global_msg', // 全局消息
  map_bubble: 'baseTile.fromws.map_bubble', // 监控屏气泡
  riskSituation_bubble: 'baseTile.fromws.riskSituation_bubble', //  业务屏风险态势图气泡
  riskSituation_colour: 'baseTile.fromws.riskSituation_colour', //  业务屏态势图颜色更改

  //预案
  plan_start: 'baseTile.view.plan_start', // 启动预案
  plan_end: 'baseTile.view.plan_end', // 结束预案
  plan_step: 'baseTile.view.plan_step', // 预案步骤
  viewTile_init: 'baseTile.view.init', // 卫星图页面恢复报警前初始状态
  stepArea_view: 'baseTile.view.stepArea',//左上步骤预览区
  helpArea_view: 'baseTile.view.helpArea',//右侧新增详情区--智能辅助
  optionArea_view: 'baseTile.view.optionArea',//交互区
  plan_detail: 'plan_detail_onclick', // 演练图标点击事件
  record_view: 'baseTile.view.recordArea', // 记录区消息
  monitor_view: 'baseTile.view.stepArea', // 监控区消息,同步骤区消息
  monitor_speed_view: 'baseTile.view.moitor', // 监控区消息,同步骤区消息
  alarm_confirm_msg: 'baseTile.view.AlarmConfirm_msg', //预案开始消息
  biz_preplan_view: 'baseTile.forward.preplan',//预案打开业务菜单
  top_afe_msg: 'baseTile.fromws.top_alarm_fire_equip_msg', //顶部传感器报警消息
  top_ae_msg: 'baseTile.fromws.top_alarm_equip_msg' //顶部重点装备报警提醒消息
};

export const isPointEvent = (topic) => topic.indexOf('.point_') > -1;
export const isControllerEvent = (topic) => topic.indexOf('.controller_') > -1;
export const isLevelFilter = (topic) => topic.indexOf('.level_filter_') > -1;
export const isManualOperate = (topic) => topic.indexOf('.manual_operate') > -1;
export const isGlobalMsg = (topic) => topic.indexOf('global_msg') > -1;
export const isSearchManualOperate = (topic) => topic.indexOf('.search_manual_operate') > -1;
export const isFireResource = (markerType) => markerType.indexOf('fireResource') > -1;

const buildTopic = ({ iFDomain, group, template }) => {
  let topic = '';
  if (utils.isEmpty(group)){
    topic = `baseTile.${iFDomain}.${template}`;
  } else {
    topic = `baseTile.${iFDomain}.${group}.${template || 'default'}`;
  }

  return topic;
};

/**
 * 组装数据，转为 { topic, content }
 * @param {object} data
 */
export const rulesDataFactory = (data) => {
  const { iFDomain, group, template, dataList, bizObj, actionId } = data || {};
  const topic = buildTopic({ iFDomain, group, template });
  const content = {
    group,
    type: template,
    data: dataList,
    bizObj,
    actionId
  };

  return {
    topic,
    content
  };
};

const conf = {
  duration: 5
};
export default function globalMsg(msg){
  const { title, content, duration = conf.duration } = msg.data;
  if (title && content) {
    Toast.error({
      title,
      content: <Paragraph html={content} />,
      placement: 'topMiddle',
      icon: false,
      duration
    });
  }
}
