import React from 'react';
import { Connect } from 'amos-framework';
import { msgAction } from '../../../../services/bizService';
import DataPaneBasic from './../common/DataPaneBasic';
import DataPaneContent from './../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from './../common/PaneItem';
import ListPaginate from './../common/ListPaginate';
import { eventTopics } from './../../consts';

const eventConnect = Connect.eventConnect;

/**
 * 消息
 * @class Msg
 * @extends {Component}
 */
@eventConnect
class Msg extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      searchName: 'title',
      data: [],
      filter: [],
      page: 0,
      pageSize: 10
    };
  }

  componentDidMount(){
    this.onSearch();
    this.props.subscribe(eventTopics.datapane_msg, (topic, data) => {
      console.log('datapane_msg****', data);
      this.onHandleMsg(data);
    });
  }
  /**
   * 点击监控中的一个
   */
  onClick = (item) => {

  }

  onHandleMsg = (data) => {
    this.onSearch();
  }

  onSearch = (page) => {
    const { filter, pageSize } = this.state;
    let time = (filter.find(e=>e.name === 'time') || {}).value || '';
    let type = (filter.find(e=>e.name === 'type') || {}).value || '';
    let title = (filter.find(e=>e.name === 'title') || {}).value || '';
    msgAction(time,type,title, page || 0, pageSize).then(d => {
      this.list.setData(d, this);
    });
  }

  delHtmlTag = (data)=> {
    return data.content.replace(/<[^>]+>/g,'');
  }

  renderItem = (item) => {
    return [
      { name: '类型', value: 'title' },
      { name: '时间', value: 'timeStr' },
      { name: '内容', value: 'content',render: this.delHtmlTag }
    ];
  }

  render() {
    const { searchName, data, pageSize } = this.state;
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        filter={Filter}
        searchName={searchName}
      >
        <ListPaginate
          ref={node => this.list = node}
          data={data}
          pageSize={pageSize}
          onChangePage={this.onSearch}
          renderItem={e => <PaneItem renderItem={this.renderItem} key={e.id} data={e} onClick={this.onClick} />}
        />
      </DataPaneContent>
    );
  }
}

export default Msg;
