import React, { Component } from 'react';
import { shortcutKeys } from './../../conf';

/**
 * 设置-快捷键
 * @class ShortcutKey
 * @extends {Component}
 */
class ShortcutKey extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  renderItem = () => {
    let res = [];
    (shortcutKeys || []).map(e => {
      res.push(<tr key={e.category} className="shortcutkey-group"><td colSpan={3}>{e.category}:</td></tr>);
      e.keys.map(item => {
        res.push(<tr key={e.name} className="shortcutkey-item"><td>{item.name}</td><td>{item.key}</td><td>{item.status}</td></tr>);
      });
    });
    return res;
  }

  render() {
    return (
      <div className="datapane-setting-shortcutkey">
        <table className="shortcutkey-table">
          <tr className="shortcutkey-header"><td>功能</td><td>热键</td><td>状态</td></tr>
          {
            this.renderItem()
          }
        </table>
      </div>
    );
  }
}

export default ShortcutKey;
