import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Icon from 'amos-icon';
import { SidePane } from 'amos-framework';

const sidepaneStyles = {
  topArea: {
    left: '50%',
    top: 100,
    bottom: 150,
    transform: 'translateX(-50%)'
  }
};

/**
 * 详情区
 *
 * @class StepContent
 * @extends {Component}
 */
class StepContent extends Component {
  render() {
    const { header, onClose, body } = this.props;
    return (
      <SidePane left={false} top={false} style={sidepaneStyles.topArea} className='step-cxt-root' >
        <div className="drawer-content" style={{ width: '500px' }}>
          <div className="drawer-content-header">
            <div className="drawer-content-header-title">
              <span>{header}</span>
            </div>
            <div className="drawer-content-header-close" onClick={onClose}>
              <Icon icon="close" />
            </div>
          </div>
          <div className="drawer-content-body">{body}</div>
        </div>
      </SidePane>
    );
  }
}

StepContent.propTypes = {
  header: PropTypes.string,
  onClose: PropTypes.func,
  body: PropTypes.node,
  left: PropTypes.number,
  top: PropTypes.number,
  width: PropTypes.number
};

export default StepContent;
