import React,{ Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import imgStatic from './../../../../consts/imgStatic';

const pointIcon = imgStatic.planDetail;

class DetailCard extends Component{
  constructor(props) {
    super(props);
    this.state = {
      display: true
    };
  }

  componentWillMount() {
    this.setState({ children: this.props.children });
  }

  onChange = (e) => {
    const { display } = this.state;
    this.setState({ display: !display });
  }

  componentWillReceiveProps(nextProps) {
    this.setState({ children: nextProps.children });
  }

  render() {
    const { display, children } = this.state;
    return (
      <div className="detailCard">
        <div className="detailCardTitle">
          <Row className="cardRow">
            <Col span={12} className="cardCol"><span className="cardTitleName">{this.props.title || ''}</span></Col>
            <Col span={12} className="card-img-pos cardCol"><a className="detailUp" onClick={this.onChange.bind(this)}><img src={display ? pointIcon.down : pointIcon.up} className="img-pos" /></a></Col>
          </Row>
        </div>
        <div className={display ? "detailCardContxt" : "detailCardContxt-notDisplay"}>
          {children}
        </div>
      </div>
    );
  }
}

DetailCard.propTypes = {
  children: PropTypes.node,
  title: PropTypes.string
};

export default DetailCard;
