import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Icon, Row, Col, Timeline } from 'amos-framework';
import DetailCard from './DetailCard';


class PersonDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {}
    };
  }

  componentWillMount() {
    this.setState({ data: this.props.data });
  }

  componentWillReceiveProps = (nextProps) => {
    this.setState({ data: nextProps.data });
  }

  getCarDetailComponent = () => {
    const { data } = this.state;
    return (
      <div>
        <DetailCard title="任务" >
          <Timeline>
            <Timeline.Item>属性</Timeline.Item>
            <Timeline.Item>条件</Timeline.Item>
            <Timeline.Item>结果</Timeline.Item>
            <Timeline.Item>动作</Timeline.Item>
          </Timeline>
        </DetailCard>
      </div>
    );
  }



  render() {
    return (
      <div>
        <div className="carHead">
          <div className="carImg"></div>
          <div>
            <div className="carBasic">
              <span className="carName">王多余</span>
              <div className="post" >
                值班班长
              </div>
            </div>
            <div className="carInfo">
              <Row>
                <Col span={8} offset={8}>
                  12345678901
                </Col>
              </Row>
            </div>
          </div>
        </div>
        <div className="carContext">
          {this.getCarDetailComponent()}
        </div>
      </div>
    );
  }
}

export default PersonDetail;
