import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import SymIcon from './../../../common/icon/SymIcon';
import DetailCard from './DetailCard';
import { baseURI } from './../../../../consts/urlConsts';

import imgStatic from './../../../../consts/imgStatic';

const pointIcon = imgStatic.planDetail;

class StationDetail extends Component {
  constructor(props) {
    super(props);
    this.state = {
      station: {}
    };
  }

  componentWillMount() {
    this.setState({ station: this.props.station });
  }


  componentWillReceiveProps  = (nextProps) => {
    this.setState({ station: nextProps.station });
  }

  getEquipmentList = (EquipmentList) => {
    return (EquipmentList || []).map((equip) => {
      return (
        <Row className="precontrol-detail-row" key={equip.name}>
          <Col span={12}>{equip.name}:</Col>
          <Col span={12}>
            {equip.count}{equip.unit || ''}
          </Col>
        </Row>
      );
    });
  }

  getDetailComponent = () => {
    const { station = {} } = this.state;
    let fireStation = station.fireStation || {};
    let EquipmentList = station.EquipmentList || [];
    return (
      <div>
        {fireStation.picture && <DetailCard title="图片" >
          <img className="preControl-car-img-size" src={baseURI+`/${station.picture}` || ''} />
        </DetailCard>}
        <DetailCard title="设备列表" >
          <div className="carInfo">
            {EquipmentList.length > 0 ? this.getEquipmentList(EquipmentList) : '无'}
          </div>
        </DetailCard>
      </div>
    );
  }

  getIcon = (type) => {
    if (type === '1') {
      return (<img src={pointIcon.xiaofangxiaoshi} alt="" />);
    } else {
      return (<SymIcon icon="paomojian" style={{ width: '59px', height: '46px' }}></SymIcon>);
    }
  }

  render() {
    const { station = {} } = this.state;
    let fireStation = station.fireStation || {};
    let icon = fireStation.type === '1' ? 'xiaofangxiaoshi' : 'paomojian';
    return (
      <div className="station">
        <div className="carHead">
          <div style={{ display: 'flex', alignItems: 'flex-start' }}>{this.getIcon(fireStation.type)}</div>
          <div className="precontrol-basic-info">
            <div className="carBasic">
              <span className="carName">{fireStation.name}</span>
            </div>
            <div className="carInfo">
              <Row>
                <Col span={6}>编码:</Col>
                <Col span={18}>
                  {fireStation.code}
                </Col>
              </Row>
              <Row>
                <Col span={6}>地址:</Col>
                <Col span={18}>
                  {fireStation.address}
                </Col>
              </Row>
            </div>
          </div>
        </div>
        <div className="carContext">
          {this.getDetailComponent()}
        </div>
      </div>
    );
  }
}

StationDetail.propTypes = {
  station: PropTypes.object
};

export default StationDetail;
