import * as endConf from 'amos-processor/lib/config/endconf';

const completePrefix = endConf.completePrefix;

const securityBaseURI = endConf.securityBaseURI;
const AmosConfig = endConf.AmosConfig;
const securityBaseWsURI = AmosConfig.wsURI.securityBaseURI;
// 三维视图
const view3dURI = AmosConfig.httpURI.view3dURI;
export const baseURI = AmosConfig.httpURI.baseURI;
const patrolURI = AmosConfig.httpURI.patrolURI;
//规则
const ruleURI = AmosConfig.httpURI.rulesConfigURI;
//监控
const monitorURI = AmosConfig.httpURI.monitorURI;
// 设备
// const deviceURI = AmosConfig.httpURI.deviceURI; 废弃

const secExVerson = 'v1';
const securityUrlWithVersion = `${securityBaseURI}/${secExVerson}`;

export const tileUrl = AmosConfig.httpURI.tileURI;
export const videoUrl = AmosConfig.outterURI.videoUrl;

export const getOutterURL = (key) => {
  return (AmosConfig.outterURI || {})[key] || '';
};

export const SecurityUrl = securityBaseURI;
export const SecurityWsUrl = securityBaseWsURI;
export const PatrolURI = patrolURI;
export const eqpAndMovingRingURI = AmosConfig.httpURI.eqpAndMovingRingURI;

/**
 * 安全模块 URL 集合
 */
export const secExtUrl = {
  //*************************************
  //  op 内置接口url
  //*************************************
  // opMenusUrl: completePrefix(securityBaseURI, 'permissionItem/allPermission-tree'),
  // opSearchMenusUrl: completePrefix(securityBaseURI, 'permissionItem/searchPermission-tree?nodeName={nodeName}&type={type}'),
  // 根据父菜单 code 获取子菜单
  // opSearchBizMenusUrl: completePrefix(securityBaseURI, 'permissionItem/searchSubmenuPermission/{code}'),

  // 获取厂区集合 get
  regionListUrl: completePrefix(baseURI, 'api/group/queryAuthCompanyLeaves'),


  // 新权限接口
  systemMenusUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/permission/tree/me`), // 获取当前系统所有菜单
  currentUserUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/agencyuser/me`), // 获取当前登陆用户信息
  permissionsCompanyUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/agencyuser/me`), // 登陆用户权限所有公司
  permissionsMenusUrl: completePrefix(securityBaseURI, `privilege/${secExVerson}/permission/tree/role?roleSeq={roleSeq}`), // 登陆用户系统权限菜单-
  //字典接口
  dictionaryValueUrl:completePrefix(securityBaseURI, `systemctl/${secExVerson}/dictionary/{dictCode}/values`),
  loginUrl: completePrefix(securityBaseURI, `${secExVerson}/system/login`), // 登陆获取accessToken
  loginOutUrl: completePrefix(securityBaseURI, `${secExVerson}/system/loginOutr`) // 登陆用户系统权限菜单
};

export const FscSerUrl = {
  //*******************************************************************************
  // 3D视图
  //*******************************************************************************
  view3dInitUrl: completePrefix(baseURI, 'view3d/initViewNode?type={type}'), // 初始化三维视图 get
  view3dInitLinkUrl: completePrefix(baseURI, 'view3d/initViewLink'), // 初始化三维视图 获取link get
  searchViewUrl: completePrefix(baseURI, '/view3d/3ddata/all?inputText={inputText}&dataLevel={dataLevel}&orgCode={orgCode}&nodeState={nodeState}&type={type}&current={page}&pageSize={pageSize}&routeName={routeName}&protectObjName={protectObjName}'), // 右侧菜单-检索
  searchLinkUrl: completePrefix(baseURI, 'view3d/link/searchView?linkId={linkId}'), // 根据单条巡检线 检索节点与线路 get
  monitorRegionListUrl: completePrefix(baseURI, 'monitorRegionListUrl'), //右侧菜单-监控-区域集合
  monitorUrl: completePrefix(baseURI, 'monitorUrl?current={page}&pageSize={size}'), //右侧菜单-监控
  msgCategoryListUrl: completePrefix(baseURI, 'msgCategoryListUrl'), //右侧菜单-消息-类别集合
  broadcastTypeListUrl: completePrefix(baseURI, 'broadcastTypeListUrl'), //右侧菜单-播报-类型集合
  // broadcastUrl1: completePrefix(baseURI, 'bizLog/query?current={page}&pageSize={size}'), //右侧菜单-播报 *
  markerDetailsUrl: completePrefix(baseURI, 'view3d/node/detail?id={id}&type={type}'), //三维地图中各种点详情
  tellRegionSelectUrl: completePrefix(baseURI, 'patrol/save/curCompany/{orgCode}'), // 注入选择的厂区信息 post

  searchRegionListUrl: completePrefix(baseURI, 'api/group/queryDept'), //右侧菜单-检索-区域集合
  recordStatusListUrl: completePrefix(baseURI, 'api/spc/check/state'), //右侧菜单-记录-状态集合
  recordUrl: completePrefix(baseURI, 'api/check/list?current={page}&pageSize={size}'), //右侧菜单-记录
  trajectoryPersonListUrl: completePrefix(baseURI, 'api/spc/queryConditions/init/{type}'), //右侧菜单-轨迹-人员集合
  trajectoryUrl: completePrefix(baseURI, 'api/spc/trajectory/list?current={page}&pageSize={size}'), //右侧菜单-轨迹
  msgUrl: completePrefix(ruleURI, 'urule/bizMessage/query?current={page}&pageSize={size}'), //右侧菜单-消息 *
  stepUrl: completePrefix(baseURI, 'api/timeline/contingency/page?current={page}&pageSize={size}'), //右侧菜单-步骤 *

  broadcastUrl: completePrefix(baseURI, 'api/timeline/{instanceNo}?recordType={recordType}'),//刷新时间轴

  // --- tile gis 瓦片
  tileEquipmentUrl: completePrefix(baseURI, 'view3d/equipmentinfo'), // 设备信息 get
  tileRiskSourceUrl: completePrefix(baseURI, 'view3d/risksource3d'), // 风险点 get
  tileVideoMonitorUrl: completePrefix(baseURI, 'view3d/videomonitorinfo3d'), // 监控设备 get

  loadPackagesUrl: completePrefix(ruleURI, 'urule/packageeditor/loadPackages?project={project}'), //风险管控查询

  pointInfoUrl: completePrefix(baseURI, 'api/spc/queryPointById/{pointId}'), // 获取巡检点详情

  tileViewTypeUrl: completePrefix(baseURI, 'tileview/viewTypeList'),//查询类型
  tileViewListUrl: completePrefix(baseURI, 'tileview/tileViewList?type={type}'),//根据类型查询列表
  bindTileViewUrl: completePrefix(baseURI, 'tileview/bindTileView'),//绑定坐标

  //*******************************************************************************
  // 巡检业务
  //*******************************************************************************
  fetchCheckDetailById: completePrefix(baseURI, 'api/spc/check-detail'), //根据ID查询巡检记录详情
  fetchCheckInputById: completePrefix(baseURI, 'api/spc/check-input'), //根据ID查询巡检记录项
  fetchUserByPd: completePrefix(baseURI, 'api/spc/check-user'),//巡检人员查询
  fetchCheckInfoByPd: completePrefix(baseURI, 'api/spc/check-info/list'),//巡检记录查询
  fetchPointQueryCriteria: completePrefix(baseURI, 'api/spc/point/queryCriteria/init'),//巡检点列表查询
  fetchPointList: completePrefix(baseURI, 'api/spc/point/list'),//巡检点列表查询
  fetchPointStatistics: completePrefix(baseURI, 'api/spc/countPoint'),//巡检点统计
  fetchChkExecuteInfo: completePrefix(baseURI, 'api/spc/checkExecute/list'),//某日巡检执行情况
  fetchMonthCountChk: completePrefix(baseURI, 'api/spc/countMonth'),  //月巡检情况统计
  fetchTaskList: completePrefix(baseURI, '/api/task/queryTaskByPage'), //月巡检情况统计
  fetchHidDangerCount: completePrefix(baseURI, 'api/task/hiddenDanger/count'),  //隐患治理统计

  fetchPointDetail: completePrefix(baseURI, 'api/spc/queryPointById'),//风险点
  fetchPointMeasures: completePrefix(baseURI, 'api/spc/measures'),//巡检点措施

  fetchPointDetailById: completePrefix(baseURI, 'api/point/queryPointById'),//巡检点明细

  detelPointMeasures: completePrefix(baseURI, '/measures/delete'),//删除巡检点措施
  batchDeletePointMeasuresAction: completePrefix(baseURI, '/measures/delete/batch'),//批量删除巡检点措施
  addPointMeasures: completePrefix(baseURI, '/measures/add'),//新增巡检点措施
  batchAddPointMeasuresAction: completePrefix(baseURI, '/measures/add/batch'),//批量新增巡检点措施
  updatePointMeasuresAction: completePrefix(baseURI, '/measures/update'),//修改巡检点措施
  fetchCalCountPanelUrl: completePrefix(baseURI, 'api/spc/check-info/count'), //查询日历对应巡检记录数量

  fetchTaskQueryCriteria: completePrefix(baseURI, 'api/task/queryCriteria/init'),//巡检点列表查询
  fetchRegionSelectUrl: completePrefix(baseURI, 'safe/save/curCompany/{orgCode}'), // 注入选择的厂区信息 GET
  userInfoByDeptIdUrl: completePrefix(baseURI, 'api/user/queryDeptUser?deptId={deptId}'), //查询部门下人员信息
  routePlanPointPageUrl: completePrefix(baseURI, 'api/spc/routePlanPoint/list'),

  //*******************************************************************************
  // 银行
  //*******************************************************************************
  impEquDetailUrl: completePrefix(baseURI, 'bank/equipment/detail?id={id}&type={type}'),//查询装备详情
  impEquPortListUrl: completePrefix(baseURI, 'bank/equipment/portList?id={id}'),//查询装备端口列表
  impEquWarnListUrl: completePrefix(baseURI, 'bank/equipment/warnList?sourceId={sourceId}&pageNumber={pageNumber}&pageSize={pageSize}'),//查询装备告警列表
  impEquInterfaceUrl: completePrefix(baseURI, 'bank/equipment/netwoerkInterface?id={id}'),//查询网络接口
  dynamicRingDataUrl: completePrefix(baseURI, 'bank/dynamicRingData/{id}'),//查询动环接口
  pointItemPatroltaUrl: completePrefix(baseURI, 'bank/equipment/pointItemPatrol?factorId={factorId}'),
  pointItemDevicetaUrl: completePrefix(baseURI, 'bank/equipment/pointItemEquipment?factorId={factorId}'),
  pointItemAllUrl: completePrefix(baseURI, 'bank/equipment/getPointItemDatas?factorId={factorId}'),

  getxuncountActionUrl: completePrefix(baseURI, 'bank/alarm/mobile/getxuncount'),
  rightTopChartDataUrl: completePrefix(baseURI, 'bank/inspection/rightTopChart?companyId={companyId}'),
  bottomTableDataUrl: completePrefix(baseURI, 'bank/inspection/bottomTable'),

  //值班信息模块
  middleHeaderDataUrl: completePrefix(baseURI, 'duty/middleHeader?orgCode={orgCode}'),
  middleTableListUrl: completePrefix(baseURI, 'duty/middleTableList?orgCode={orgCode}&id={id}'),

  middleHeaderAction1:completePrefix(baseURI, 'bank/inspection/patrolPlanList?start={start}&end={end}&deptId={depId}&deptName={deptName}'),
  getporintAction:completePrefix(baseURI, 'bank/inspection/getporint?pointid={pointid}'),
  // 告警数据
  alarmDataUrl: completePrefix(baseURI, 'bank/alarm/list'),
  sevenDaysalarmDataUrl: completePrefix(baseURI, 'bank/alarm/statistics'),
  getMobileShowDateUrl: completePrefix(baseURI, 'bank/alarm/mobile/show'),
  // impEquAlarmUrl: completePrefix(deviceURI, 'alarm/equipAttr'),
  // metricDataUrl: completePrefix(deviceURI, 'metricdata/listMongoData'),
  //*******************************************************************************
  // 监控屏首页
  //*******************************************************************************
  //leftMetricDataUrl: completePrefix(baseURI, 'api/message/mobile/getcountxd') ,//查询左侧风险数据
  leftDangerDataUrl: completePrefix(baseURI, 'alarm/mobile/getcountxd'), //查询左侧风险数据
  leftMetricDataUrl: completePrefix(baseURI, 'bank/alarm/mobile/getcountxd')//查询左侧风险数据

  //leftMetricDataUrl1: completePrefix(deviceURI, '/device/statisticDeviceByAlarmLevel?orgCode={code}'), //查询左侧风险数据
  // leftMetricDataUrl1: completePrefix(deviceURI, '/metricdata/statisticMongoData'),
  // leftMetricDataUrl2: completePrefix(deviceURI, 'device/statisticDeviceByModel?orgCode={code}') //查询左侧设备
};
export const FasSerUrl = {
  //*******************************************************************************
  // 换流站视图
  //*******************************************************************************
  riskLevelListUrl: completePrefix(baseURI, 'api/riskLevel/pagelist?pageNumber={page}&pageSize={size}'),
  accidentTypeListUrl: completePrefix(baseURI, 'api/accidentType/pagelist?pageNumber={page}&pageSize={size}'),
  riskFactorListUrl: completePrefix(baseURI, 'api/riskFactor/pagelist?pageNumber={page}&pageSize={size}'),
  evaModelListUrl: completePrefix(baseURI, 'api/fmeaEvaluate/list?type={type}'),
  fireTruckListUrl: completePrefix(baseURI, 'api/fireSource/fire-car/list?pageNumber={page}&pageSize={size}'),  //获取消防车列表
  fireTruckDetailUrl: completePrefix(baseURI, 'api/fireSource/fire-car/det/{id}'),  //获取消防车相信信息
  riskLevelEditUrl: completePrefix(baseURI, 'api/riskLevel/editRiskLevel'),
  riskLevelDetUrl: completePrefix(baseURI, 'api/riskLevel/deleteRiskLevelById'),
  accidentTypelEditUrl: completePrefix(baseURI, 'api/accidentType/editAccidentType'),
  accidentTypelDetUrl: completePrefix(baseURI, 'api/accidentType/deleteAccidentTypeById'),
  riskFactorEditUrl: completePrefix(baseURI, 'api/riskFactor/editRiskFactor'),
  riskFactorDetUrl: completePrefix(baseURI, 'api/riskFactor/deleteRiskFactorById'),
  fireSourceListUrl: completePrefix(baseURI, 'api/impEquip/list?pageNumber={page}&pageSize={size}'),   //获取重点设备列表
  // fireEquipmentListUrl: completePrefix(baseURI, 'api/fireSource/fire-equip/list?pageNumber={page}&pageSize={size}'),  //获取消防装备列表
  fireEquipmentListUrl: completePrefix(baseURI, 'api/fireSource/info/page?name={name}&code={code}&equipClassify={equipClassify}&pageNumber={page}&pageSize={size}'),  //获取消防装备列表
  monitorPointListUrl: completePrefix(baseURI, 'api/firequment/point/fireequipment/{fireEqumtId}/page?pageNumber={page}&pageSize={size}'),  //获取消防装备已配置监测点位列表
  monitorPointEditUrl: completePrefix(baseURI, 'api/firequment/point'),  //新增/更新消防装备监测点位
  monitorPointDeleteUrl: completePrefix(baseURI, 'api/firequment/point/{ids}'),  //删除消防装备监测点位
  monitorPointQryEditUrl: completePrefix(baseURI, 'api/firequment/point/{id}'),  //获取消防装备监测点位
  equipmentListQryUrl: completePrefix(baseURI, 'api/impEquip/list?pageNumber={page}&pageSize={size}'),   //获取重点设备列表
  accidentTypeNoPageListUrl: completePrefix(baseURI, 'api/accidentType/all-list'),
  matchEquipmentListUrl: completePrefix(baseURI, 'api/impEquip/{equipmentId}/fireeqmt/page?pageNumber={page}&pageSize={size}'),  //获取重点设备的配套装备列表
  alarmInfoListUrl: completePrefix(baseURI, 'api/alarm/pagelist?pageNumber={page}&pageSize={size}'),//报警信息列表查询
  areaPlistUrl: completePrefix(baseURI, 'api/fireSource/fire-equip/area'),//生产区域查询查询
  equipNoPageListUrl: completePrefix(baseURI, 'api/impEquip/all-list'), //保护对象查询
  matchEquipmentUnBindUrl: completePrefix(baseURI, 'api/impEquip/{equipmentId}/fireeqmt/{fireEquipmentId}'), //删除配套设备
  matchEquipmentBindUrl: completePrefix(baseURI, 'api/impEquip/{id}/fireeqmt'), // 绑定配套设备
  equipmentPrePlanPictureUrl: completePrefix(baseURI, 'api/impEquip/pre-picture?equipId={equipmentId}&type={type}') ,//获取重点设备预控图
  femaEditUrl: completePrefix(baseURI, 'api/riskModel/fmea/editFmea'), //fmea编辑
  fmeaDeleteUrl: completePrefix(baseURI, 'api/riskModel/fmea/deleteFmea'), //fmea删除
  fmeaPageListUrl: completePrefix(baseURI, 'api/riskModel/fmea/list?pageNumber={page}&pageSize={size}'),  //fmea分页查询
  dangerFactorPageListUrl: completePrefix(baseURI, 'api/riskModel/dangerFactor/list?pageNumber={page}&pageSize={size}'),  //模型危险因素分页查询
  assoPointListUrl: completePrefix(baseURI, 'api/risksource/getBindPoints?riskSourceId={riskSourceId}&pageNumber={page}&pageSize={size}'),
  assoEquipListUrl: completePrefix(baseURI, 'api/risksource/{riskSourceId}/fireequiment/relations?pageNumber={page}&pageSize={size}'),
  riskFactorNoPageUrl: completePrefix(baseURI, 'api/riskFactor/all-list'),
  deptByOrgCodeUrl: completePrefix(baseURI, 'api/common/deptment/list'),//部门查询,
  pointListUrl: completePrefix(baseURI, 'api/common/pointList?pageNumber={page}&pageSize={size}'),//巡检点查询
  pointInputListUrl: completePrefix(baseURI, 'api/common/pointInputlist?pageNumber={page}&pageSize={size}'),//巡检点项查询
  bindPointUrl: completePrefix(baseURI, 'api/risksource/bindPoints/{riskSourceId}'),//巡检点关联
  riskSourceRpnCountUrl: completePrefix(baseURI,'api/risksource/rpn/list'),  // 查询风险点RPN统计
  bindEquipListUrl: completePrefix(baseURI, 'api/risksource/{riskSourceId}/fireequiment/relation/all?equimentId={equimentId}&fname={fname}&pageNumber={page}&pageSize={size}'),//配套设施查询（已绑定及未绑定）
  bindEquipUrl: completePrefix(baseURI, 'api/risksource/{riskSourceId}/fireequiment/relation'),
  deleteBindEquipUrl: completePrefix(baseURI, 'api/risksource/fireequiment/relation/{ids}'),
  removeByRSIdAndPIdUrl: completePrefix(baseURI, 'api/risksource/removeByRSIdAndPId'),//删除绑定的设备
  riskSourceMatrixUrl: completePrefix(baseURI,'api/risksource/matrix'),  // 查询风险点发生率/严重度矩阵
  riskSourceRiseRateUrl: completePrefix(baseURI,'api/risksource/riseuprate'),  // 查询风险点风险上升率
  equipmentDeleteUrl: completePrefix(baseURI, 'api/impEquip/{ids}'),  //删除重点设备
  equipmentGetUrl: completePrefix(baseURI, 'api/impEquip/{id}'),//获取重点设备
  fireStationGetUrl: completePrefix(baseURI, 'api/firestation/list'), //获取消防小室信息
  fireStationPageUrl: completePrefix(baseURI, '/api/firestation/page?pageNumber={page}&pageSize={size}'),//消防小室
  fireStationDetailUrl: completePrefix(baseURI,'/api/firestation/{id}'),  // 消防小室
  fireStationDeleteUrl: completePrefix(baseURI,'/api/firestation/{ids}'),  // 消防小室删除
  fireStationNewUrl: completePrefix(baseURI,'/api/firestation'),  // 消防小室新增
  fireStationEditUrl: completePrefix(baseURI,'/api/firestation/{id}'),  // 消防小室修改
  fireWaterPageUrl: completePrefix(baseURI, '/api/waterresource/page?pageNumber={page}&pageSize={size}'),//消防水资源
  fireWaterDetailUrl: completePrefix(baseURI,'/api/waterresource/{id}'),  // 消防水资源
  fireWaterDeleteUrl: completePrefix(baseURI,'/api/waterresource/{ids}'),  // 消防水资源
  fireWaterNewUrl: completePrefix(baseURI,'/api/waterresource'),  // 消防水资源
  fireWaterEditUrl: completePrefix(baseURI,'/api/waterresource/{id}'),  //消防水资源
  userListGetByDeptIdUrl: completePrefix(baseURI, 'api/common/{departmentId}/user/list'), //获取部门下用户信息
  equipmentAddUrl: completePrefix(baseURI, 'api/impEquip'), //添加重点设备
  fireEquipmentDeleteUrl: completePrefix(baseURI, 'api/fireSource/{ids}'), //删除消防设备
  fireEquipmentGetUrl: completePrefix(baseURI, 'api/fireSource/{id}'), //获取消防设备信息
  fireEquipmentAddUrl: completePrefix(baseURI, 'api/fireSource'), //添加消防设备
  fireTruckDeleteUrl: completePrefix(baseURI, 'api/firecar/{ids}'), //删除消防车
  fireTruckAddUrl: completePrefix(baseURI, 'api/firecar/uploadCarImg'), //添加消防车
  fireStrengthPageUrl: completePrefix(baseURI, 'api/firestrength/page?pageNumber={page}&pageSize={size}'), //消防力量
  fireStrengthDetailUrl: completePrefix(baseURI, 'api/firestrength/{id}'), //消防力量
  fireStrengthDeleteUrl: completePrefix(baseURI, 'api/firestrength/{ids}'), //消防力量
  fireStrengthNewUrl: completePrefix(baseURI, 'api/firestrength'), //消防力量
  fireStrengthEditUrl: completePrefix(baseURI, 'api/firestrength/{id}'), //消防力量
  fireStationMatchesAddUrl: completePrefix(baseURI, 'api/firestation/fireequipmenet'),   //消防小室添加配套消防装备
  fireStationMatchesListUrl: completePrefix(baseURI, 'api/firestation/{fireStationId}/fireequipmenet/page?pageNumber={page}&pageSize={size}'),  //获取消防站的配套装备列表
  fireStationMatchesDeleteUrl: completePrefix(baseURI, 'api/firestation/fireequipmenet'),   //删除消防站绑定的消防装备
  dialogPointDetailUrl: completePrefix(baseURI, 'api/fireSource/info/detail?id={dialogId}&type={type}'),
  fireEquipmentHistoryDataUrl: completePrefix(baseURI, 'api/fireSource/data/history?fireEquipmentName={fireEquipmentName}&equipmentName={equipmentName}&startTime={startTime}&endTime={endTime}&pageNumber={page}&pageSize={size}'),//消防设备历史数据列表
  riskSoureWarningUrl: completePrefix(baseURI, 'api/risksource/warning/detail?riskSourceId={riskSourceId}'),//风险预警详情
  screenSaverDataUrl: completePrefix(baseURI, 'api/risksource/collection3d'),  //3d屏保数据
  equipmentUpdateUrl: completePrefix(baseURI, 'api/impEquip/uploadEquipmentImg'),  //更新重点设备
  getRegionAreaRpnUrl: completePrefix(baseURI, 'api/risksource/queryRiskAreaRpn'), // 获取厂区下所有区域rpn值
  getFireStationInfoUrl: completePrefix(baseURI, 'api/firestation/createAndSaveImg'),// 维护消防小室/消防泡沫间信息
  riskSourceRpniUpdateUrl: completePrefix(baseURI, 'api/risksource/updateRiskSourceRpni'), //fmea修改时更新风险点rpni值
  reginSelectUrl: completePrefix(baseURI, 'api/region/selected') //选择公司

};

export const SpcSerUrl = {
  //*******************************************************************************
  // 渭化业务接口URL
  //*******************************************************************************
  getIdentificationMethodUrl: completePrefix(baseURI, 'api/spcIdentificationMethod/list?pageNumber={page}&pageSize={size}'), //获取风险辨识方法分页列表
  identificationMethodSaveUrl: completePrefix(baseURI, 'api/spcIdentificationMethod/identificationMethod'), //保存风险辨识方法
  getEvaluateModelListUrl: completePrefix(baseURI, 'api/spcEvaluateModel/list?pageNumber={page}&pageSize={size}'), //获取风险辨识方法分页列表
  evaluateModelSaveUrl: completePrefix(baseURI, 'api/spcEvaluateModel/save'), //保存风险评价模型
  evaluateModelDeleteUrl: completePrefix(baseURI, 'api/spcEvaluateModel/delete/{ids}'), //删除风险评价模型
  getRiskLevelListUrl: completePrefix(baseURI, 'api/spcRiskLevel/list?pageNumber={page}&pageSize={size}'), //获取风险等级分页列表
  riskLevelSaveUrl: completePrefix(baseURI, 'api/spcRiskLevel/save'), //保存风险等级
  riskLevelDeleteUrl: completePrefix(baseURI, 'api/spcRiskLevel/delete/{ids}'), //删除风险等级
  getEvaluateCriteriaListUrl: completePrefix(baseURI, 'api/spcEvaluateNorm/list?pageNumber={page}&pageSize={size}'), //获取风险评价准则分页列表
  evaluateCriteriaSaveUrl: completePrefix(baseURI, 'api/spcEvaluateNorm/save'), //保存风险评价准则
  evaluateCriteriaDeleteUrl: completePrefix(baseURI, 'api/spcEvaluateNorm/delete/{ids}') ,//删除风险评价准则
  hazardSourceClassifyListUrl: completePrefix(baseURI, 'api/spcHazardSourceClassify/pagelist?pageNumber={page}&pageSize={size}'),//危险源列表查询
  hazardSourceClassifySaveUrl: completePrefix(baseURI, 'api/spcHazardSourceClassify/save'),//危险源保存
  hazardSourceClassifyDeleteUrl: completePrefix(baseURI, 'api/spcHazardSourceClassify/delEntryByIds'),//危险源删除
  aftermathListUrl: completePrefix(baseURI, 'api/spcAftermath/pagelist?pageNumber={page}&pageSize={size}'),//后果列表查询
  aftermathSaveUrl: completePrefix(baseURI, 'api/spcAftermath/save'),//后果保存,
  aftermathDeleteUrl: completePrefix(baseURI, 'api/spcAftermath/delEntryByIds'),//后果删除
  controlMeasureListUrl: completePrefix(baseURI, 'api/spcControlMeasure/pagelist?pageNumber={page}&pageSize={size}'),//管控措施列表查询
  controlMeasureSaveUrl: completePrefix(baseURI, 'api/spcControlMeasure/save'),//管控措施保存
  controlMeasureDeleteUrl: completePrefix(baseURI, 'api/spcControlMeasure/delEntryByIds'),//管控措施删除
  controlMeasureDetailUrl: completePrefix(baseURI, 'api/spcControlMeasure/getDetailById/{id}'),//管控措施明细
  measureContentDeleteUrl: completePrefix(baseURI, 'api/spcMeasureContent/{id}'),//管控措施内容删除
  riskTypeEumUrl: completePrefix(baseURI, 'api/spcRiskSource/riskType'),//风险源类型查询
  dangerFactorSaveUrl: completePrefix(baseURI, 'api/spcRiskFactor/save'),//危险因素保存
  dangerFactorDeleteUrl: completePrefix(baseURI, 'api/spcRiskFactor/delete/{ids}'),//删除风险因素
  dangerFactorDetailUrl: completePrefix(baseURI,'api/spcRiskFactor/{id}'),//危险因素明细
  camerasListUrl: completePrefix(baseURI, 'api/spcCamera/list?pageNumber={page}&pageSize={size}'),//摄像头列表查询,
  camerasDeleteUrl: completePrefix(baseURI, 'api/spcCamera/camera/{ids}'), //删除摄像头
  camerasSaveUrl: completePrefix(baseURI, 'api/spcCamera/camera'), //保存摄像头
  riskSourceTreeUrl: completePrefix(baseURI, 'api/spcRiskSource/riskSourceTress'),//风险点树查询
  riskSourceSaveUrl: completePrefix(baseURI, 'api/spcRiskSource/save'),//风险点编辑
  riskSourceDeleteUrl: completePrefix(baseURI, 'api/spcRiskSource/delete/{ids}'),//风险点删除
  riskLevelEumListUrl: completePrefix(baseURI, 'api/spcRiskLevel/list'),//下拉查询
  evaluateModelRiskLeveListUrl: completePrefix(baseURI, 'api/spcRiskLevel/{evModelId}/list'),//风险评价模型下的风险等级下拉查询
  dangerFactorPageListUrl: completePrefix(baseURI, 'api/spcRiskFactor/list?pageNumber={page}&pageSize={size}'),//危险因素列表分页查询,
  riskSourceDetailUrl: completePrefix(baseURI, 'api/spcRiskSource/details/{id}'),//查询风险点明细
  equipmentListUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/list?pageNumber={page}&pageSize={size}'),//设备设施列表查询
  equipmentODeleteUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/euipmentFacilities/{ids}'), //设备设施删除
  equipmentOperateUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/euipmentFacilities'), //设备设施保存
  getRegionDepartmentTreeUrl: completePrefix(baseURI, 'api/spcSecurity/department/listTree'), //获取区域部门树
  taskworkUnPageListUrl: completePrefix(baseURI, 'api/spcTaskwork/list-all'),//获取所有作业活动
  userDataUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/euipmentFacilities'),//获取用户下拉数据
  methodDataUrl: completePrefix(baseURI, 'api/spcIdentificationMethod/list/all'),//获取辨识方法下拉数据
  areaDataUrl: completePrefix(baseURI, 'api/spcRiskSource/details'),//分区
  mgtCtrlEquipDetailUrl: completePrefix(baseURI, 'api/spcRiskFactor/controlObject/details/{riskFactorId}'),//管控措施详情设备设施危险因素
  teamDataUrl: completePrefix(baseURI, 'api/spcRiskSource/details'), //班组
  controlMeasureUrl: completePrefix(baseURI, 'api/spcRiskFactor/controlMeasure/details/{riskFactorId}/{evaluateId}'),//安全管控状态明细状态查询
  relateEquipMgtUrl: completePrefix(baseURI, 'api/spcRiskFactor/equipment'),//关联设备设施
  relateTaskworkMgtUrl: completePrefix(baseURI, 'api/spcRiskFactor/taskwork'),//关联作业活动
  getEquipmentRegionOptionsUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/equipment/option/listByCondition?regionId={regionId}&departmentId={departmentId}'), // 获取设备设施下拉选项-1
  getEquipmentNameOptionsUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/equipment/option/listByCondition?regionId={regionId}&departmentId={departmentId}&workshopSection={workshopSection}'), // 获取设备设施下拉选项-2
  matchesCamerasUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/bingCameras/{equipId}'),//获取绑定的摄像头列表
  bindCamerasUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/equipment/{equipId}/bingCameras/{cameraIds}'),//摄像头绑定设备设施
  unBindCamerasUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/equipment/{equipId}/unbindCameras/{cameraIds}'),//摄像头与设备设施解除绑定
  spcEuipmentFacilitiesUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/{id}'),//设备设施详情
  getEquipmentCodeOptionsUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/equipment/option/listByCondition?regionId={regionId}&departmentId={departmentId}&workshopSection={workshopSection}&name={controlObjectName}'), // 获取设备设施下拉选项-3
  companyUserTreeUrl: completePrefix(baseURI, 'api/spcSecurity/user/listAll'), //根据选择公司id获取人员树
  companyUserWithDepartmentTreeUrl: completePrefix(baseURI, 'api/spcSecurity/user/listAllUserWithDepartment'), //根据选择公司id获取人员树,人员id前面添加部门id
  startWorkFlowUrl: completePrefix(baseURI, 'api/spcRiskFactor/startBatchFlow?riskFactorIds={riskFactorIds}'), // 启动工作流
  catalogEumUrl: completePrefix(baseURI, 'api/spcControlMeasure/categorys'),//获取管控措施类别
  typeEumUrl: completePrefix(baseURI, 'api/spcControlMeasure/types'),//获取管控措施类型
  getDeptUserListUrl: completePrefix(securityBaseURI, 'v1/user/list/dept/{deptId}'), //根据部门ID获取部门下用户列表
  camerasTypeEumUrl: completePrefix(baseURI, 'api/spcCamera/types'),//获取摄像头类型枚举
  equipTypeEumUrl: completePrefix(baseURI, 'api/spcEuipmentFacilities/types'),//设备设施类型
  view3dInitUrl: completePrefix(baseURI, 'view3d/initViewNode?type={type}&orgCode={orgCode}'), // 3d初始化三维视图
  view3dRiskInitUrl: completePrefix(baseURI, 'api/risksource/initViewNode?type={type}&orgCode={orgCode}'), // 初始化三维视图 get
  //riskSoureDetail3dUrl: completePrefix(baseURI, 'view3d/riskSourceDetails?id={id}'),//3d风险详情
  riskSoureDetail3dUrl: completePrefix(baseURI, 'api/risksource/riskSourceDetails?id={id}'),//3d风险详情(get风险模块)
  dangerDetail3dUrl: completePrefix(baseURI, 'view3d/dangerDetails?id={id}'),//3d隐患详情
  euqipmentDetail3dUrl: completePrefix(baseURI, 'view3d/euqipmentDetails?id={id}'),//3d设备设施详情
  // riskAreaListQueryUrl: completePrefix(baseURI, 'api/riskList/source/list?pageNumber={page}&pageSize={size}'),//风险清单-风险区域表分页查询
  // riskLocationListQueryUrl: completePrefix(baseURI, 'api/riskList/source/list?pageNumber={page}&pageSize={size}'),//风险清单-风险位置表分页查询
  riskSourceListQueryUrl: completePrefix(baseURI, 'api/riskList/source/list'),//风险清单-风险源（区域、位置）表分页查询
  equipHazardSourceListQueryUrl: completePrefix(baseURI, 'api/riskList/equipment/list'),//风险清单-设备设施危险源表分页查询
  controlObjFactorListQueryUrl: completePrefix(baseURI, 'api/riskList/factor/list') ,//风险清单-设备设施/作业活动危险因素表分页查询
  riskSourceListUrl: completePrefix(baseURI, 'api/spcRiskSource/list?pageNumber={page}&pageSize={size}') ,//风险清单二维码分页查询
  search3dListUrl: completePrefix(baseURI, 'view3d/resourceData?type={type}&pageNumber={page}&pageSize={size}'),//右侧检索
  selectedOrgInfoUrl: completePrefix(baseURI, 'api/region/current'),//获取选择的公司
  msgUrl: completePrefix(baseURI, 'api/message/page?time={time}&type={type}&title={title}&pageNumber={page}&pageSize={size}'),
  getRiskLevelAllListUrl: completePrefix(baseURI, 'api/spcRiskLevel/list'), //获取所有等下等级列表
  getRiskLevelTreeUrl: completePrefix(baseURI, 'api/spcRiskLevel/tree'), //获取所有模型下等级树
  regionSelectUrl: completePrefix(baseURI, 'api/region/selected'), //选择公司
  getInherentIndexDataUrl: completePrefix(baseURI, 'api/statistics/pie/riskFactor/riseRate'), //获取固有风险指数数据
  getOverdueDangerDataUrl: completePrefix(baseURI, 'api/statistics/pie/latentDanger/rateGroupByDepartment'), //获取隐患逾期统计数据
  getRiskDataByDeptUrl: completePrefix(baseURI, 'api/statistics/bar/riskSource/groupByDepartment'), //获取风险按部门统计数据
  getDangerDataByDeptUrl: completePrefix(baseURI, 'api/statistics/bar/latentDanger/groupByDepartment'), //获取隐患按部门统计数据
  checkListUrl: completePrefix(baseURI, 'api/statistics/patrol/plan/list?pageIndex={pageIndex}&pageSize={pageSize}&deptId={deptId}'),//当前检查计划执行情况
  getDangerListDataUrl: completePrefix(baseURI, 'api/riskList/danger/list'), //获取隐患清单数据
  exportDangerListUrl: completePrefix(baseURI, 'api/riskList/danger/exportList'), //导出隐患清单数据
  taskworkListUrl: completePrefix(baseURI, 'api/spcTaskwork/list?pageNumber={page}&pageSize={size}'), //获取作业活动列表
  taskworkTypeUrl: completePrefix(baseURI, 'api/spcTaskwork/types'), //获取作业活动类型
  taskworkSaveUrl: completePrefix(baseURI, 'api/spcTaskwork/save'), //保存作业活动
  taskworkDeleteUrl: completePrefix(baseURI, 'api/spcTaskwork/{taskworkId}'), //删除作业活动
  taskworkDetailGetUrl: completePrefix(baseURI, 'api/spcTaskwork/{taskworkId}/detail'), //获取作业活动详情
  taskworkContentDetailUrl: completePrefix(baseURI, 'api/spcTaskwork/taskworkContentDetail/{taskworkContentId}'), //获取
  taskworkContentDeleteUrl: completePrefix(baseURI, 'api/spcTaskwork/content/{contentId}'), //删除作业活动步骤
  majorHazardInstallationListQueryUrl: completePrefix(baseURI, 'api/spcMajorHazardInstallation/list') ,//风险清单-重大危险源分页查询
  majorHazardInstallationDeleteUrl: completePrefix(baseURI, 'api/spcMajorHazardInstallation?ids={ids}'),//重大危险源删除
  majorHazardInstallationSaveUrl: completePrefix(baseURI, 'api/spcMajorHazardInstallation'),//重大危险源保存
  majorHazardInstallationDetailGetUrl: completePrefix(baseURI, 'api/spcMajorHazardInstallation/{id}/detail'),//获取重大危险源信息
  riskSourceUrl: completePrefix(baseURI, 'api/spcRiskSource/list/{type}'),//查询风险层级
  riskSoureFloorDataUrl: completePrefix(baseURI, 'api/spcRiskSource/queryByFloor?orgCode={orgCode}&floor={floor}'),  //风险点
  updateRiskSourePosition3dUrl: completePrefix(baseURI, 'api/spcRiskSource/updatePosition3dById'),  //风险点三维坐标更新

  //*******************************************************************************
  // pams业务接口URL
  //*******************************************************************************
  getTopoTreeUrl: completePrefix(baseURI, 'bank/topography/tree'), //pams树
  getTopographyUrl: completePrefix(baseURI, 'bank/topography/nodes'), //pams拓扑图
  updateTopographyUrl: completePrefix(baseURI, 'bank/topography/nodes'), //pams拓扑图更新数据
  getTopographyEventsUrl: completePrefix(baseURI, 'bank/topography/events'), //pams拓扑图事件列表
  getWebTreeUrl: completePrefix(baseURI, 'bank/topography/webTree'), //net树
  addWebTreeUrl: completePrefix(baseURI, 'bank/topography/addWebTree'), //net树新增节点
  delWebTreeUrl: completePrefix(baseURI, 'bank/topography/webTree'), //net树删除节点
  getNetTopoUrl: completePrefix(baseURI, 'bank/topography/webNodes'), //net拓扑图
  updateNetTopoUrl: completePrefix(baseURI, 'bank/topography/webNodes'), //net拓扑图更新数据
  nodeDetailTopoUrl: completePrefix(baseURI, 'bank/topography/nodeDetail'), //net拓扑图节点详情
  getDyTreeUrl: completePrefix(baseURI, 'bank/topography/donghuanTree'), //动环树
  getDyTopoUrl: completePrefix(baseURI, 'bank/topography/donghuanNodes'), //动环拓扑图
  updateDyTopoUrl: completePrefix(baseURI, 'bank/topography/donghuanNodes'), //动环拓扑图更新数据
  nodeDetailDyTopoUrl: completePrefix(baseURI, 'bank/topography/nodeDetail'), //动环拓扑图节点详情
  emTopoUrl: completePrefix(baseURI, 'bank/topography/deviceNodes') ,//设备拓扑图

//*******************************************************************************
  // 自建系统业务接口URL
  //*******************************************************************************
  getSelfTopoTreeUrl: completePrefix(baseURI, 'bank/topography/selftree'), //自建系统树
  getSelfTopographyUrl: completePrefix(baseURI, 'bank/topography/selfnodes'), //自建系统树节点
  updateSelfUrl: completePrefix(baseURI, 'bank/topography/selfnodes'), //更新自建系统节点
  listSelfDevice: completePrefix(baseURI, 'bank/equipment/selfDevice?fname={fname}&pageNumber={page}&pageSize={size}'),

  getTopoTreeByTypeUrl: completePrefix(baseURI, 'bank/topography/treeByType/{type}'), //监控系统树
  getNodesByTypeAndTreeIdUrl: completePrefix(baseURI, 'bank/topography/getNodesByTypeAndTreeId/{type}/{treeId}'), //根据类型查询拓扑图列表
  saveNodesByTypeUrl: completePrefix(baseURI, 'bank/topography/saveNodesByType/{type}'), //保存拓扑图数据
};

export const patrolUrls = {
  inputItemTablesUrl: completePrefix(baseURI, 'api/inputItem/queryItemByPage?pageNumber={page}&pageSize={size}'),
  inputItemBatchDelUrl: completePrefix(baseURI, 'api/inputItem/batchDelItem?itemIDs={ids}'),
  inputItemSaveAsUrl: completePrefix(baseURI, 'api/inputItem/saveAs?itemIDs={ids}'),
  inputItemSaveUrl: completePrefix(baseURI, 'api/inputItem/addItem'),
  pointListGetUrl: completePrefix(baseURI, 'api/point/list?pageNumber={page}&pageSize={size}'), // 获取巡检点列表
  pointSaveAsUrl: completePrefix(baseURI, 'api/point/saveAs?ids={ids}'), // 点另存为
  pointDeleteUrl: completePrefix(baseURI, 'api/point/deletePoint?ids={ids}'), // 删除点
  routeListGetUrl: completePrefix(baseURI, 'api/route/list'), //获取路线
  inputItemDetailUrl: completePrefix(baseURI, 'api/inputItem/queryItem?itemID={itemID}'),
  planInfoTablesUrl: completePrefix(baseURI, 'api/plan/list?pageNumber={page}&pageSize={size}'),
  pointAddUrl: completePrefix(baseURI, 'api/point/addPoint'), // 新增点
  planSaveUrl: completePrefix(baseURI, 'api/plan/addPlan'),
  deptByOrgCodeUrl: completePrefix(baseURI, 'api/group/queryDept'),
  userInfoByDeptIdUrl: completePrefix(baseURI, 'api/user/queryDeptUser?deptId={deptId}'),
  userTreeGetByCompanyIdUrl: completePrefix(securityBaseURI, '/user/user-tree/{companyId}?roleType={roleType}'),  // 获取公司下属所有部门及部门下的用户构建的树(可指定角色类型)
  taskPageUrl: completePrefix(baseURI, 'api/task/queryTaskByPage?pageNumber={page}&pageSize={size}'),
  taskBatchDelUrl: completePrefix(baseURI, '/api/task/batchDelTask?taskIDs={ids}'),
  taskHandleUrl: completePrefix(baseURI, '/api/task/handleTask?taskIds={ids}&status={status}'),
  taskDetailUrl: completePrefix(baseURI, '/api/task/queryTask?taskID={id}'),
  taskAddUrl: completePrefix(baseURI, '/api/task/addTask'),
  deptUserTreeUrl: completePrefix(baseURI, '/api/user/queryDeptUserTree'),
  taskFeedbackTaskUrl: completePrefix(baseURI, '/api/task/feedbackTask'),
  routePageUrl: completePrefix(baseURI, 'api/route/list?pageNumber={page}&pageSize={size}'),
  routeBatchDelUrl: completePrefix(baseURI, 'api/route/deleteRoute?routeIds={ids}'),
  routeAddUrl: completePrefix(baseURI, 'api/route/addRoute'),
  routeDetailUrl: completePrefix(baseURI, '/api/route/queryRouteById/{id}'),
  routeUpdateUrl: completePrefix(baseURI, 'api/route/updateRoute'),
  routePointPageUrl: completePrefix(baseURI, 'api/route/listRoutePoint?routeId={id}&pageNumber={page}&pageSize={size}'),
  planDetByPlanIdUrl: completePrefix(baseURI, 'api/plan/detail/{planId}'),
  routePointBatchDelUrl: completePrefix(baseURI, 'api/route/deleteRoutePoint?pointIds={pointIds}&routeId={routeId}'),
  RoutePointMigrateUrl: completePrefix(baseURI, 'api/route/migrateRoutePoint?sourceRouteId={sourceRouteId}&pointIds={pointIds}&targetRouteId={targetRouteId}'),
  routeUrl: completePrefix(baseURI, 'api/route/All'),
  routePointsAuthUrl: completePrefix(baseURI, 'api/point/queryPoints?code={code}&name={name}'),
  routePointAddUrl: completePrefix(baseURI, 'api/route/addRoutePoint?routeId={routeId}&pointIds={pointIds}'),
  pointInputItemUrl: completePrefix(baseURI, 'api/point/queryPointInputItem?pointId={pointId}'), // pointInputItemUrl
  inputItemQueryByConditionUrl: completePrefix(baseURI, 'api/inputItem/queryItemByCondition'),
  inputItemQueryByConditionUrl1: completePrefix(baseURI, 'api/inputItem/queryItemByCondition1'),
  planSaveAsUrl: completePrefix(baseURI, 'api/plan/saveAs'),
  planBatchDetUrl: completePrefix(baseURI, 'api/plan/deletePlanById'),
  planTaskTablesUrl: completePrefix(baseURI, 'api/planTask/list?pageNumber={page}&pageSize={size}'),
  reGenplanTaskUrl: completePrefix(baseURI, 'api/planTask/regenPlanTask'),
  deleteplanTaskUrl: completePrefix(baseURI, 'api/planTask/deletePlanTask'),
  pointQueryByIdUrl: completePrefix(baseURI, '/api/point/queryPointById/{pointId}'),
  planInfoNoPageUrl: completePrefix(baseURI, 'api/plan/queryPlanByOrgCode'),
  taskPrintUrl: completePrefix(baseURI, '/api/task/printTask?taskID={taskID}'),
//  pointInputItemQueryUrl: completePrefix(baseURI, 'api/point/queryPointInputItem?pointId={pointId}'), //  pointInputItemUrl
  pointClassifyWithInputItemQueryUrl: completePrefix(baseURI, 'api/point/queryPointClassifyWithInputItem?pointId={pointId}'),
  routePointInputItemUrl: completePrefix(baseURI, 'api/route/listRoutePointInputItem'),
  routePointInputItemUpdateUrl: completePrefix(baseURI, '/api/route/updateRoutePointInputItem?routeId={routeId}&pointId={pointId}&inputItemIds={inputItemIds}'),
  companysUrl: completePrefix(baseURI, 'api/group/queryAuthCompanyLeaves'),
  saveSelectCompanyUrl: completePrefix(baseURI, 'safe/save/curCompany/{orgCode}'),
  checkTablesUrl: completePrefix(baseURI, 'api/check/list?pageNumber={page}&pageSize={size}'),
  pointUpdateUrl: completePrefix(baseURI, 'api/point/updatePoint'),
  checkBatchDetUrl: completePrefix(baseURI, 'api/check/deleteCheckById'),
  catalogTreeUrl: completePrefix(baseURI, 'api/catalogTree/getCatalogTree'),
  catalogTreeSaveUrl: completePrefix(baseURI, 'api/catalogTree/addCatalogTree'),
  catalogTreeBatDelUrl: completePrefix(baseURI, 'api/catalogTree/deleteCatalogTreeById'),
  catalogTreeListUrl: completePrefix(baseURI, 'api/catalogTree/list?pageNumber={page}&pageSize={size}'),
  catalogTreeDetByIdUrl: completePrefix(baseURI, 'api/catalogTree/catalogTreeDetById/{id}'),
  forwardTaskUrl: completePrefix(baseURI, '/api/task/forwardTask?userId={userId}&taskID={taskID}'),
  checkDetailUrl: completePrefix(baseURI, '/api/check/queryCheckInfo?checkId={checkId}'),
  exportCheckRecordUrl: completePrefix(baseURI, 'api/check/export'),
  exportCheckRecordImgsUrl: completePrefix(baseURI, 'api/check/exportImgs'),
  checkRecordImgsExportByIdsUrl: completePrefix(baseURI, 'api/check/exportImgsByIds?ids={ids}'),
  exportSelectRecordUrl: completePrefix(baseURI, 'api/check/exportSelectRecord?ids={ids}'),
  exportListPointUrl: completePrefix(baseURI, 'api/point/exportListPoint?exportType={exportType}'),
  exportSelectedPointListUrl: completePrefix(baseURI, 'api/point/exportListPointByIds?ids={ids}&exportType={exportType}'),
  exportPointTemplateUrl: completePrefix(baseURI, 'api/point/exportTemplate'),
  importPointUrl: completePrefix(baseURI, 'api/point/import'),
  reportPlanTaskUrl: completePrefix(baseURI, 'api/planTask/reportPlanTask'),
  exportSelectPlanTaskUrl: completePrefix(baseURI, 'api/planTask/exportSelectPlanTask?ids={ids}'),
  pointNoQueryUrl: completePrefix(baseURI, '/api/point/queryPointNo/{pointId}'),
  itemNoQueryUrl: completePrefix(baseURI, '/api/inputItem/queryItemNo/{itemId}'),
  exchangeOrderNumberUrl: completePrefix(baseURI, '/api/route/exchangeOrderNumber?src={src}&target={target}'),
  //消息提醒
  getNewsListUrl: completePrefix(baseURI, 'api/msgSubscribe/list?pageNumber={page}&pageSize={size}'),//分页获取消息提醒集合
  sendNewsUrl: completePrefix(baseURI, 'api/msgSubscribe/noticePublish'),//发送消息通知
  repeatNewsUrl: completePrefix(baseURI, ''),//重发消息
  deleteNewsUrl: completePrefix(baseURI, ''),//删除消息提醒
  newsTypeListUrl: completePrefix(baseURI, 'api/msgSubscribe/MsgType'),//获取消息类型集合
  newsPersonDataUrl: completePrefix(baseURI, 'api/user/queryDeptUserTree'),//获取消息接受人员
  //查询统计
  completionSituationUrl: completePrefix(baseURI, 'api/task/report/{statistical}?startDate={startDate}&endDate={endDate}&planId={planId}&routeId={routeId}'),
  completionSituationExportUrl: completePrefix(baseURI, 'api/excel/task/{statistical}?startDate={startDate}&endDate={endDate}&planId={planId}&routeId={routeId}'),//巡检完成情况月报表-表格导出
  caliberListUrl: completePrefix(baseURI, 'api/common/checkStatisticsType'),//巡检完成情况月报表-获取统计口径集合
  planListUrl: completePrefix(baseURI, 'api/plan/queryPlanList'),//巡检完成情况月报表-获取所属计划集合
  lineListUrl: completePrefix(baseURI, 'api/route/routeList'),//巡检完成情况月报表-所属线路集合

  executeStateListUrl: completePrefix(baseURI, 'api/common/planTaskExecution'),//巡检情况统计分析-执行情况集合
  inspectionSituationListUrl: completePrefix(baseURI, 'api/check/statisticalAnalysis'),//巡检情况统计分析-表格
  inspectionSituationExportUrl: completePrefix(baseURI, 'api/check/exportStatisticalAnalysis'),//巡检情况统计分析-表格导出
  taskArrangementListUrl: completePrefix(baseURI, 'api/task/getStatisticsData'),//任务安排统计分析-表格
  taskArrangementExportUrl: completePrefix(baseURI, 'api/task/exportStatisticsData'),//任务安排统计分析-表格导出
  taskCaliberListUrl: completePrefix(baseURI, 'api/common/taskgetStatisticsType'),//任务安排统计分析-获取任务统计口径集合
  personStatisticsUrl: completePrefix(baseURI, 'api/task/report/comprehensive/user?startTime={startTime}&endTime={endTime}'),//人员综合统计分析-表格
  personStatisticsExportUrl: completePrefix(baseURI, 'api/excel/comprehensive/user?startTime={startTime}&endTime={endTime}'),//人员综合统计分析-表格导出

  homeNumberUrl: completePrefix(baseURI, 'api/home/overviewData'),//巡检首页-获取公司名、巡检点数、完成/计划、累计巡检次数、未完/已完任务数和巡检点数
  homeChartUrl: completePrefix(baseURI, 'api/home/getCheckData'),//巡检首页-获取12日内 实际巡检、计划巡检和漏检次数每天的数值
  currentCompanyUrl: completePrefix(baseURI, 'api/user/queryLoginUserAndCompany'),//当前系统公司信息
  SpecCheckDetailUrl: completePrefix(baseURI, 'api/spc/check-detail'),//查询检查项详情
  SpecCheckInputById: completePrefix(baseURI, 'api/spc/check-input'), //根据ID查询巡检记录项
  searchCheckShortUrl: completePrefix(baseURI, 'api/check/getCheckPic?checkId={checkId}&checkInputId={checkInputId}&classifyId={classifyId}'), //根据检查项ID和检查项输入ID查询图片

  taskworkStartUrl: completePrefix(baseURI, 'api/taskwork/startFlow?taskworkIds={taskworkIds}'), //启动作业活动流程
  //getWarningsDataUrl: completePrefix(baseURI, 'bank/warn/getWarnings'), //查询告警信息列表

  getWarningsDataUrl: completePrefix(baseURI, 'bank/warn/getWarnings'), //查询告警信息列表
  getWarningsByPageData: completePrefix(baseURI, 'alarm/alarmPage?pageNumber={page}&pageSize={size}'), //查询告警信息列表
  exportWarningsExcelUrl: completePrefix(baseURI, 'bank/warn/excel'), //告警信息导出excel
  getPointDataUrl: completePrefix(baseURI, 'view3d/getpointlist?code={orgCode}&floor={floor}'), //查询巡检点列表
  updatePointPosition3dUrl: completePrefix(baseURI, 'view3d/updatepoint?id={id}&coordinates={position}') //更新巡检点三维坐标
};

export const MonitorUrl = {
  getMonitorsByPageDataUrl: completePrefix(baseURI, 'rtsp/listVideoByPage'), //监控视频分页查询
  getMonitorsTreeUrl: completePrefix(baseURI, 'rtsp/monitorVideoTree'), //视频监控左侧树列表
  getMonitorsByFloor3dUrl: completePrefix(baseURI, 'rtsp/list?floor3d={floor}&orgCode={orgCode}'), //根据行政编码和楼层查询监控信息
  updateMonitorPosition3dUrl: completePrefix(baseURI, 'video/updateDevice'), //更新监控点三维坐标
  updateDynamicRingPosition3dUrl: completePrefix(baseURI, '/bank/dynamicRingData/update') //更新监控点三维坐标
};

// export const DeviceURI = { 废弃
//   dynamicRingDataUrl: completePrefix(deviceURI, '/mericdata/equip/{id}')//查询动环数据接口
// };

export const securityKey = 'qianyue(xian),fsc,xunjianpassword';

export const pamsTable = {
  equipmentDetailUrl: completePrefix(baseURI, 'bank/equipment/detail?id={id}&type={type}') //获取网络设备数据
};

export const _mapCenter = AmosConfig.mapCenter;
export const _showZoom = AmosConfig.showZoom;
export const _picURI = AmosConfig.httpURI.picURI;

export const eqpAndMovingRing = {
  // url: completePrefix(eqpAndMovingRingURI, 'xml/alarm?xmlData={str}')
  url: completePrefix(baseURI, 'bank/alarm/tigger?xmlData={str}')
};

export const AisleUrl = {
  aisleListUrl: completePrefix(baseURI, 'bank/alarm/aislelist?city={city}'), //根据城市查询对应通道信息及状态
  topoAisleListUrl: completePrefix(baseURI, 'bank/alarm/topoAislelist'), //查询拓扑图告警通道
  bankInfoListUrl: completePrefix(baseURI, 'bank/alarm/bankInfoList') //查询银行经纬度列表
};
