import * as endConf from 'amos-processor/lib/config/endconf';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import SysConsts from 'amos-processor/lib/config/consts';
import { Store } from 'amos-tool';

const completePrefix = endConf.completePrefix;

const AmosConfig = endConf.AmosConfig;
const baseURI = AmosConfig.wsURI.baseURI;
const rulesURI = AmosConfig.wsURI.rulesConfigURI;
const viewTileURI = AmosConfig.wsURI.viewTileURI;
const lsTool = Store.lsTool;

const getToken = () => {
  return lsTool.read(SysConsts.token);
};

export default {
  rulews: completePrefix(rulesURI, 'rule.ws?token={token}'),
  view3dws: completePrefix(baseURI, 'alarmPoint'),
  topChartws: completePrefix(baseURI, 'routeChartData'),
  situationws: completePrefix(baseURI, 'spcMessage'),//业务屏数据同步消息
  viewTileURI: completePrefix(viewTileURI, 'rule.ws'),
  netTopoURI: completePrefix(baseURI, 'topography'), //网络拓扑图消息
  pamsTopoURI: completePrefix(baseURI, 'pams'), //pams拓扑图消息
  dyTopoURI: completePrefix(baseURI, 'donghuan'), //动环拓扑图消息
  selfURI: completePrefix(baseURI, 'self'), 
  sbTopoURI: completePrefix(baseURI, 'shebei'),//设备监控拓扑图消息
  towMapURI: completePrefix(baseURI, 'gj'),//GPS轨迹坐标消息
  aisleURI: completePrefix(baseURI, 'aisleAlarm'), //首页地图通道消息
  planTaskURI: completePrefix(baseURI, 'plantask') ,//巡检推送消息（刷新支付业务和巡检计划执行情况）
  technologyIpURI: completePrefix(baseURI, 'technologyIp'), //科技处设备ping IP
};

export const completeToken = (url) => {
  const token = getToken();
  const result = formatUrl(url, { token });
  return result;
};
