import combineRoutes from 'amos-pluggable/lib/combineRoutes';
import MatchEquipment from './../view/bizview/equipmentLedger/Equipment/MatchEquipment';
import FireStationMatches from './../view/bizview/equipmentLedger/FireResources/matchEquipment/FireStationMatches';
import FireTruckDetailInfo from './../view/bizview/equipmentLedger/FireResources/FireTruck/FireTruckDetailInfo';
import PointInfo from './../view/bizview/pointInfo/index';
import CheckList from './../view/bizview/xjcheck/CheckList';
import DifferentiateDetail from './../view/bizview/intelligentDifferentiate/DifferentiateDetail';
import EquipCamera from './../view/bizview/safetyControlObj/equipmentsAndFacilities/cameraBind/EquipCamera';
import CheckDetail from './../view/bizview/check/checkDetail/index';
import MgtCtrlModel from './../view/bizview/preControl/mgtCtrlModel';

/**
 * 系统自定义路由
 */
export const customRoutes = [
  { path: 'stationmatches', parent: 'biz', component: FireStationMatches },
  { path: 'matchequipment', parent: 'biz', component: MatchEquipment },
  { path: 'firetruckinfo', parent: 'biz', component: FireTruckDetailInfo },
  { path: 'pointInfo', parent: 'patrolpoint', component: PointInfo },
  { path: 'checklist', parent: 'patrolpoint', component: CheckList },
  { path: 'differentiateDetail', parent: 'biz', component: DifferentiateDetail },
  { path: 'equipCamera', parent: 'mgtCtrlModel', component: EquipCamera },
  { path: 'checkDetailInfo', parent: 'biz', component: CheckDetail },
  { path: 'mgtCtrlModel', parent: 'biz', component: MgtCtrlModel }
];


/**
 * path mapping
 *
 * import { parseText } from 'amos-tool';
 * const stage = parseText(pathMapping.stage, { objkey });
 */
export const pathMapping = {
  // stage: '/main/config/rulecenter/stage/{objkey}'
  pointList: '/biz/patrolpoint', //巡检点列表
  pointCheckList: '/biz/patrolpoint/checklist', //巡检点检查清单

  pointCheckDetail: '/biz/patrolpoint/checkdetail', //巡检点检查详情
  pointInfo: '/biz/patrolpoint/pointInfo', //
  dangerList: '/biz/task', //隐患治理信息
  matchEquipment: '/biz/matchequipment',  //重点设备配套装备
  equipment: '/biz/equipment', //重点设备
  waterResource: '/biz/waterResource',
  stationResource: '/biz/stationResource',
  stationMatches: '/biz/stationmatches', //消防小室/泡沫间配套装备
  firetruckinfo: '/biz/firetruckinfo', //消防车详情
  riskModel: '/biz/riskModel',
  differentiateDetail: '/biz/differentiateDetail', // 智能判别详情
  equipCamera: '/biz/equipCamera', // 设备设施绑定摄像机
  mgtCtrlModel: '/biz/mgtCtrlModel', // 管控模型
  checkDetailInfo: '/biz/checkDetailInfo',
  checkRecordList: '/biz/checkRecordList'
};

export const activitiMapping = {
  checkStandard: 'hidden/securityCheck',
  checkPlan: 'hidden/Check',
  execute: '',
  identification: 'judged/RiskJudged',
  announcement: 'judged/BulletinLedger',
  dailyInformation: 'judged/CurrentJudged',
  judgedSummary: 'judged/JudgedSummary',
  mytoDo: 'workbench/MytoDo',
  mytoHave: 'workbench/MytoHave',
  processTo: 'workbench/ProcessTo',
  warningCurve: 'securityWarning/warningCurve',
  warningIndicators: 'securityWarning/warningIndicatorConfig',
  thresholdConfiguration: 'securityWarning/thresholdConfig',
  warningIndicatorManage: 'securityWarning/warningIndicatorManage'
};

/**
 * 将自定义路由添加到主路由上
 * @param {*} mainRoutes
 */
const addCustomRoutes = mainRoutes => combineRoutes(mainRoutes, customRoutes);

export default addCustomRoutes;
