import { commonGet, commonPost, singleFetch } from './../utils/request';
//import * as helper from 'base-r3d/lib/utils/helper';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { FscSerUrl } from './../consts/urlConsts';

const mockFetch = (jsonUrl) => {
  return commonGet(jsonUrl);
};
/**
 * 二维图获取轨迹数据
 */
export const getTracks = function(fireKey, carCodes) {
  return mockFetch('/src/_mock/map/map.json');
};

/**
 * 二维图获取轨迹数据
 */
export const getTrack = (url, callback) => {
  return singleFetch(url).then(data => {
    //const objs = helper.parseModelConfig(data);
    const { linePaths,personTell,personCompany } = data;
    callback(linePaths,personTell,personCompany);
  });
};

export const getLeftMetricDataAction = (params) => {
  return commonPost(formatUrl(FscSerUrl.leftMetricDataUrl),{ code: params.code });
};

export const getLeftMetricDataAction1 = (params) => {
   return commonPost(formatUrl(FscSerUrl.leftMetricDataUrl1),params);
 // return commonGet(formatUrl(FscSerUrl.leftMetricDataUrl1, {  code }));
};

export const getLeftMetricDataAction2 = (code) => {
  return commonGet(formatUrl(FscSerUrl.leftMetricDataUrl2, {  code }));
};

export const getLeftDangerDataAction = (params) => {
  return commonPost(formatUrl(FscSerUrl.leftDangerDataUrl),{ code: params.code });
};
