import { SpcSerUrl } from './../consts/urlConsts';
import { commonPost, commonGet, formatUrl } from './../utils/request';


// 监控系统树查询
export const getTopoTreeByTypeAction = (type) => {
  return commonGet(formatUrl(SpcSerUrl.getTopoTreeByTypeUrl, { type }));
};

// 拓扑图查询
export const getNodesByTypeAndTreeIdAction = (type, treeId) => {
  return commonGet(formatUrl(SpcSerUrl.getNodesByTypeAndTreeIdUrl, { type, treeId }));
};

//  拓扑图更新数据
export const saveNodesByTypeUrlAction = (type, params) => {
  return commonPost(formatUrl(SpcSerUrl.saveNodesByTypeUrl, { type }), params);
};


