import { SpcSerUrl, AisleUrl } from './../consts/urlConsts';
import { commonPost, commonGet } from './../utils/request';

// pams 树
export const getTopoTreeAction = () => {
  let url = SpcSerUrl.getTopoTreeUrl;
  return commonGet(url);
};

// pams 拓扑图
export const getTopographyAction = (treeid) => {
  let url = `${SpcSerUrl.getTopographyUrl}/${treeid}`;
  return commonGet(url);
};

// pams 拓扑图更新数据
export const updateTopographyAction = (params) => {
  let url = SpcSerUrl.updateTopographyUrl;
  return commonPost(url,params);
};

// pams 拓扑图事件列表
export const getTopographyEventsAction = () => {
  let url = SpcSerUrl.getTopographyEventsUrl;
  return commonGet(url);
};

// pams 拓扑图告警通道
export const getTopoAisleListAction = () => {
  let url = AisleUrl.topoAisleListUrl;
  return commonGet(url);
};
