import { commonGet } from '../utils/request';
import { pamsTable } from '../consts/urlConsts';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { singleFetch } from './../utils/request';

/**
 * 获取网络设备数据
 */
export const getEquipmentDetail = (id,type) => {
  return commonGet(formatUrl(pamsTable.equipmentDetailUrl,{id, type }));
};


/**
 * 获取环境参数状态数据
 */
export const getSurroundingsList = (url, callback) => {
  return singleFetch(url).then(data => {
    const { surroundingsList } = data;
    callback(surroundingsList);
  });
};

/**
 * 获取环境参数状态数据
 */
export const getPortList = (url, callback) => {
  return singleFetch(url).then(data => {
    const { portList } = data;
    callback(portList);
  });
};

/**
 * 获取路由表数据
 */
export const getRouterList = (url, callback) => {
  return singleFetch(url).then(data => {
    const { routerList } = data;
    callback(routerList);
  });
};

/**
 * 获取路由表数据
 */
export const getForwardList = (url, callback) => {
  return singleFetch(url).then(data => {
    const { fwordList } = data;
    callback(fwordList);
  });
};

/**
 * 获取ARP数据
 */
export const getARPList = (url, callback) => {
  return singleFetch(url).then(data => {
    const { ARPList } = data;
    callback(ARPList);
  });
};

/**
 * 获取预警数据
 */
export const getAlertList = (url, callback) => {
  return singleFetch(url).then(data => {
    const { alertList } = data;
    callback(alertList);
  });
};
