import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { FasSerUrl } from './../consts/urlConsts';
import { commonGet, commonPost, commonDelete } from './../utils/request';

export const queryRiskLevelAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.riskLevelListUrl, { page, size }), filter);
};

export const queryAccidentTypelAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.accidentTypeListUrl, { page, size }), filter);
};

export const queryRiskFactorAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.riskFactorListUrl, { page, size }), filter);
};

export const queryEvaModelAction = (type) => {
  return commonGet(formatUrl(FasSerUrl.evaModelListUrl, { type }));
};

export const riskLevelEditAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.riskLevelEditUrl), body);
};

export const riskLevelDeleteAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.riskLevelDetUrl), body);
};

export const accidentTypelEditAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.accidentTypelEditUrl), body);
};

export const accidentTypelDeleteAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.accidentTypelDetUrl), body);
};

export const riskFactorEditAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.riskFactorEditUrl), body);
};

export const riskFactorDeleteAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.riskFactorDetUrl), body);
};

export const accidentTypeNoPageAction = () => {
  return commonGet(formatUrl(FasSerUrl.accidentTypeNoPageListUrl), {});
};

export const femaEditAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.femaEditUrl), body);
};

export const fmeaDeleteAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.fmeaDeleteUrl), body);
};

export const fmeaPageListAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.fmeaPageListUrl, { page, size }), filter);
};

export const queryAssoPointListAction = (riskSourceId, page, size) => {
  return commonGet(formatUrl(FasSerUrl.assoPointListUrl, { riskSourceId, page, size }));
};

export const queryRiskFactorNoPageAction = () => {
  return commonGet(formatUrl(FasSerUrl.riskFactorNoPageUrl, {}));
};

export const queryAssoEquipListAction = (riskSourceId, page, size) => {
  return commonGet(formatUrl(FasSerUrl.assoEquipListUrl, {riskSourceId, page, size}));
};

export const queryDeptByOrgCodeAction = () => {
  return commonGet(formatUrl(FasSerUrl.deptByOrgCodeUrl, {}));
};

export const queryPointPageListAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.pointListUrl, { page, size }), filter);
};

export const queryPointInputPageListAction = (filter, page, size) => {
  return commonPost(formatUrl(FasSerUrl.pointInputListUrl, { page, size }), filter);
};

export const bindPointsAction = (riskSourceId, body) => {
  return commonPost(formatUrl(FasSerUrl.bindPointUrl, { riskSourceId }), body);
};

export const bindEquipListAction = (riskSourceId , equimentId, page, size,fname) => {
  return commonGet(formatUrl(FasSerUrl.bindEquipListUrl, {riskSourceId,equimentId,fname,page,size}));
};

export const bindEquipAction = (riskSourceId, body) => {
  return commonPost(formatUrl(FasSerUrl.bindEquipUrl, { riskSourceId }), body);
};

export const deleteBindEquipAction = (ids) => {
  return commonDelete(formatUrl(FasSerUrl.deleteBindEquipUrl, {ids}));
};

export const deleteAssoPointAction = (body) => {
  return commonPost(formatUrl(FasSerUrl.removeByRSIdAndPIdUrl), body);
};

/**
 * 根据部门ID获取部门下人员
 *
 * @param {*} body
 */
export const getUsersByDepartmentIdAction = (departmentId) => {
  return commonGet(formatUrl(FasSerUrl.userListGetByDeptIdUrl, { departmentId }));
};

export const updateRiskSourceRpniAction = (body) => {
  let url = formatUrl(FasSerUrl.riskSourceRpniUpdateUrl);
  return commonPost(url, body);
};

export const reginSelectAction = (body) => {
  let url = formatUrl(FasSerUrl.reginSelectUrl);
  return commonPost(url, body);
};
