
import * as endConf from 'amos-processor/lib/config/endconf';
import formatUrl from 'amos-processor/lib/utils/urlFormat';
import { commonPut,commonGet } from './../utils/request';
import { baseURI, FscSerUrl } from './../consts/urlConsts';

const completePrefix = endConf.completePrefix;


/**
 * 调用规则通用服务
 */
export const ruleAction = (content,confirm) => {
  let requestUrl = completePrefix(baseURI,`${content.requestUrl}?batchNo=${content.batchNo}&stepCode=${content.stepCode}&buttonCode=${content.code}&confirm=${confirm}&contingencyPlanId=${content.contingencyPlanId}&stepState=${content.stepState}`);
  return commonPut(requestUrl, {});
};

/**
 * 预案重新播放
 */
export const ruleRePlayAction = (batchNo) => {
  return commonGet(formatUrl(FscSerUrl.ruleRePlayUrl,{ batchNo }));
};
