// 所有与UAP相关的资源文件，尽量均放在改配置文件同级目录下
!(function() {
  const UAPConf = {
    // 通用 header
    header: {
      logo: {
        url: '/uaconf/logo.svg', // logo image url
        width: '',
        height: '',
        backgroundColor: '',
        paddingLeft: '',
        paddingTop: '',
        paddingBottom: ''
      },
      text: {
        content: '安全生产预控系统',
        fontSize: '',
        fontFamily: '',
        fontColor: '',
        fontWeight: '',
        backgroundColor: '',
        paddingLeft: ''
      },
      sub: {
        content: '',
        fontFamily: '',
        fontSize: '',
        fontWeight: '',
        fontStretch: '',
        lineHeight: '',
        letterSpacing: '',
        color: '',
        paddingLeft: ''
      },
      background: {
        color: '' // 背景颜色
      }
    },
    // 登录界面
    login: {
      // 除了 url 之外，其余参数可以自定义添加 style 属性
      background: {
        url: '', // logo image url
        background: '',
        width: '',
        height: ''
      },
      descr: {
        title: {
          content: '',
          fontSize: 57,
          fontFamily: '',
          fontColor: '',
          fontWeight: ''
        },
        subTitle: {
          content: ``,
          fontSize: 30,
          fontFamily: '',
          fontColor: '',
          fontWeight: ''
        }
      },
      // 设置为 null， 或者 content 设置为 空，即可隐藏
      fotter: {
        content: '',
        fontSize: 16,
        fontFamily: '',
        fontColor: '',
        fontWeight: ''
      },
      // form 表单配置项
      form: {
        logo: {
          url: '/uaconf/logo.svg', // logo image url
          width: '',
          height: ''
        },
        text: {
          content: '安全生产预控系统',
          fontSize: 26
        },
        background: {
          width: '',
          height: '',
          backgroundImage: ''
        },
        formItem: {
          iconStyle: {
            color: ''
          },
          inputStyle: {
            width: '100%',
            height: '',
            backgroundColor: '',
            borderRadius: '',
            border: '',
            color: ''
          },
          rememberedStyle: {
            color: ''
          },
          buttonStyle: {
            width: '',
            height: '',
            backgroundColor: '',
            borderRadius: '',
            border: ''
          }
        }
      },
      // 是否显示验证码
      showVerifyCode: false
    },
    // 应用列表界面
    application: {
      // 除了 url 之外，其余参数可以自定义添加 style 属性
      background: {
        url: '', // logo image url
        width: '',
        height: ''
      },
      appItem: {
        // item 文本样式
        textStyle: {
          fontSize: '',
          color: 'red'
        },
        // item 图片样式
        imageStyle: {
          width: '',
          height: ''
        }
      }
    }
  };

  var b = document.createElement('style');
  b.innerText = `
    #app .afv-login-header {
      background: #c9000b;
      z-index: 1;
    }
    #app .afv-login-background {
      height: 100%;
      top: 0;
      background: url(/uaconf/bg.png) no-repeat;
    }
    #app .afv-login-content-area {
      right: 14%;
      background: rgb(255 255 255 / 0.8);
    }

    #app .login-logo img {
      height: 90px;
      margin-bottom: 0rem;
    }

    #app .login-logo-text {
      color: #b2030c;
      letter-spacing: 5px;
    }

    #app .afv-login-form .sso-input {
      width: 289px;
    }

    #app .afv-login-form .sso-input .amos-input::hover {
      border-color: #b2030c;
    }

    #app .afv-login-form .sso-input .aficon {
      font-size: 21px;
      color: #b2030c;
      position: relative;
      right: -2px;
      display: inline-block;
    }

    #app .afv-login-form .amos-btn {
      width: 288px;
      height: 54px;
      font-size: 22px;
      background-color: #b2030c;
      border: 1px solid #b2030c;
      border-radius: 4px;
      margin-top: 30px;
    }

    #app .afv-login-form .amos-btn::hover {
      background-color: #b2030c;
      border: 1px solid #b2030c;
      opacity: 0.9;
    }

    #app .view-port .header {
      background: #c9000b;
    }

    #app .view-port .header .sys-tools {
      border-left: 0;
    }

    #app .view-port .header .header-navs .logo-wrapper {
      display: inline-block;
    }

    .app-item-footer {
      color: white !important;
      text-shadow: rgb(52, 95, 166) 0px 0px 0.2em !important;
    }

    #app .setting-box-img {
      height: 100%;
      display: flex;
      align-items: center;
    }

    #app .app-list-content-one {
      margin-top: 9vw;
    }

    #app .setting-box-img img {
      width: 24px;
      height: 24px;
    }

    #app .header .user-area .amos-single-pop-trigger {
      height: 42px;
      line-height: 42px;
      display: flex;
      align-items: center;
    }

    #app .header .user-area .amos-avatar {
      width: 24px;
      height: 24px;
      border-radius: 4px;
    }

    #app .app-center {
      background: transparent;
      position: relative;
    }

    #app .app-center::before {
      content: "";
      background: url(/uaconf/application.png) no-repeat;
      position: absolute;
      top: 0;
      width: 100%;
      height: 100%;
      z-index: 0;
    }
  `;
  document.head.appendChild(b);
  window.UAPConf = UAPConf;
})();
