/**
 * 直线生成平滑曲线Util
 * @param {point_start} 起点经纬度
 * @param {point_end} 终点经纬度
 * @param {num} 生成点个数
 * @param {key} 曲线弯曲程度
 */
export const calcCoorArrUtil = (point_start, point_end, num, key) => {
  var p_start = { x: point_start.lng, y: point_start.lat };
  var p_end = { x: point_end.lng, y: point_end.lat };
  let x3 = (p_start.x * key + p_end.x * key - p_start.y + p_end.y) / (2 * key)
  let y3 = (p_start.y * key + p_end.y * key - p_end.x + p_start.x) / (2 * key)
  var p_crt1 = { x: x3, y: y3 };
  var p_crt2 = { x: x3, y: y3 };
  let paths = [];
  for (let i = 0; i < num + 1; i++) {
    let t = i / num;
    var _matrix1 = [1, t, t * t, t * t * t];
    var _matrix2 = [
      [1, 0, 0, 0]
      , [-3, 3, 0, 0]
      , [3, -6, 3, 0]
      , [-1, 3, -3, 1]
    ];
    var _matrix3 = [
      [p_start.x, p_start.y]
      , [p_crt1.x, p_crt1.y]
      , [p_crt2.x, p_crt2.y]
      , [p_end.x, p_end.y]
    ];
    var _matrix_tmp = [
      _matrix1[0] * _matrix2[0][0] + _matrix1[1] * _matrix2[1][0] + _matrix1[2] * _matrix2[2][0] + _matrix1[3] * _matrix2[3][0]
      , _matrix1[0] * _matrix2[0][1] + _matrix1[1] * _matrix2[1][1] + _matrix1[2] * _matrix2[2][1] + _matrix1[3] * _matrix2[3][1]
      , _matrix1[0] * _matrix2[0][2] + _matrix1[1] * _matrix2[1][2] + _matrix1[2] * _matrix2[2][2] + _matrix1[3] * _matrix2[3][2]
      , _matrix1[0] * _matrix2[0][3] + _matrix1[1] * _matrix2[1][3] + _matrix1[2] * _matrix2[2][3] + _matrix1[3] * _matrix2[3][3]
    ];
    var _matrix_final = [
      _matrix_tmp[0] * _matrix3[0][0] + _matrix_tmp[1] * _matrix3[1][0] + _matrix_tmp[2] * _matrix3[2][0] + _matrix_tmp[3] * _matrix3[3][0]
      , _matrix_tmp[0] * _matrix3[0][1] + _matrix_tmp[1] * _matrix3[1][1] + _matrix_tmp[2] * _matrix3[2][1] + _matrix_tmp[3] * _matrix3[3][1]
    ];

    var _res_point = [_matrix_final[1], _matrix_final[0]];

    paths.push(
      {
        longitude: _matrix_final[0],
        latitude: _matrix_final[1]
      }
    );
  }
  return paths;
};

/**
 * 语言播放
 */
export function text2Speech(content){
  if ('speechSynthesis' in window) {
    let sentence = new SpeechSynthesisUtterance(content);
    let voices = window.speechSynthesis.getVoices();
    for (let i = 0; i < voices.length; i++) {
      if (voices[i]['name'] === 'Alex') {
        sentence.voice = voices[i];
      }
    }
    sentence.pitch = 1;
    sentence.rate = 1.5;//速度
    sentence.text = content;
    window.speechSynthesis.speak(sentence);
  } else {
    console.log('当前浏览器不支持语音朗读.');
  }
}

