
import moment from 'moment';


// 获取今天天的开始结束时间

export default {

// 获取今天天的开始结束时间
getToday() {
  let date = {};
  date.beginDate = moment().startOf('day').format('YYYY-MM-DD HH:mm:ss');
  date.endDate =  moment().endOf('day').format('YYYY-MM-DD HH:mm:ss');
  return date
},

// 获取昨天的开始结束时间
getYesterday (){
  let date = {};
  date.beginDate = moment().subtract('days', 1).startOf('day').format('YYYY-MM-DD HH:mm:ss');
  date.endDate =  moment().subtract('days', 1).endOf('day').format('YYYY-MM-DD HH:mm:ss');
  return date
},

// 获取本月的开始结束时间
gettCurrMonthDays () {
  let date = {};
  date.beginDate = moment().startOf('month').format('YYYY-MM-DD HH:mm:ss');
  date.endDate =  moment().endOf('month').format('YYYY-MM-DD HH:mm:ss');
  return date;
},

// 获取上一个月的开始结束时间
getLastMonthDays (){
  let date = {};
  date.beginDate = moment().subtract('month', 1).startOf('month').format('YYYY-MM-DD HH:mm:ss');
  date.endDate = moment().subtract('month', 1).endOf('month').format('YYYY-MM-DD HH:mm:ss');
  return date;
},
// 获取当前周的开始结束时间
getCurrWeekDays (){
  let date = {};
  date.beginDate = moment().startOf('isoWeek').format('YYYY-MM-DD HH:mm:ss'); // 周一日期
  date.endDate = moment().endOf('isoWeek').format('YYYY-MM-DD HH:mm:ss') ;// 周日日期
  return date;
},
// 获取上一周的开始结束时间
getLastWeekDays(){
  let date = {};
  date.beginDate = moment().week(moment().week() - 1).startOf('isoWeek').format('YYYY-MM-DD HH:mm:ss');
  date.endDate = moment().week(moment().week() - 1).endOf('isoWeek').format('YYYY-MM-DD HH:mm:ss');
  return date
},

// 获取最近七天的开始结束时间
getLast7Days(){
  let date = {};
  date.beginDate = moment().subtract('days', 7).startOf('day').format('YYYY-MM-DD HH:mm:ss');
  date.endDate = moment().endOf('day').format('YYYY-MM-DD HH:mm:ss');
  return date;
},
// 获取最近30天的开始结束时间
getLast30Days(){
  let date = {};
  date.beginDate = moment().subtract('days', 30).startOf('day').format('YYYY-MM-DD HH:mm:ss');
  date.endDate = moment().endOf('day').format('YYYY-MM-DD HH:mm:ss');
  return date;
},

// 获取最近12月开始结束时间
getLast12MonthDays (){
  let date = {};
  date.beginDate = moment().year(moment().year()-1).startOf('day').format('YYYY-MM-DD HH:mm:ss');
  date.endDate = moment().endOf('day').format('YYYY-MM-DD HH:mm:ss');
  return date;
},

// 获取今年的开始结束时间
getThisYearDays(){
  let date = {};
  date.beginDate = moment().startOf('year').format('YYYY-MM-DD HH:mm:ss');
  date.endDate = moment().endOf('year').format('YYYY-MM-DD HH:mm:ss');
  return date;
},

// 获取去年的开始结束时间
getLastYearDays(){
  let date = {};
  date.beginDate = moment().year(moment().year()-1).startOf('year').format('YYYY-MM-DD HH:mm:ss');
  date.endDate = moment().year(moment().year()-1).endOf('year').format('YYYY-MM-DD HH:mm:ss');
  return date;
}
}
