import React from 'react';
import PropTypes from 'prop-types';
import { Progress } from 'amos-framework';

const LoadingComs = props => {
  const { percent, tip } = props;
  return (
    <div className="obj-loading-coms">
      <Progress percent={percent} size="lg" />
      <div className="loading-tip">{tip}</div>
    </div>
  );
};

LoadingComs.propTypes = {
  percent: PropTypes.number,
  tip: PropTypes.string
};

export default LoadingComs;
