import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import SysWsURL, { completeToken } from './../../consts/wsUrlConsts';
import SideControl from './sideControl';
import DataPane from './datapane';
import Explain from './explain';
import RulesLayer from './global/RulesLayer';
import globalMsg from './pagefactory/msgFactory';
import { eventTopics, rulesDataFactory } from './consts';

const eventConnect = Connect.eventConnect;

@eventConnect
class MaskContent extends Component {

  /**
   * 监控视图消息 (规则 ws)
   */
  handleData = data => {
    console.log('rule ws data:', data);
    const { topic, content } = rulesDataFactory(data);
    if (topic === eventTopics.global_msg) {
      this.props.hiddenScreenSaver();
      globalMsg(content);
      return;
    }
    const { onTrigger } = this.props;
    onTrigger && onTrigger(topic,content);
  };

  render() {
    const { multiple, onItemClick, layerConfig, showExplain, onExplainClose } = this.props;
    const wsURL = completeToken(SysWsURL.rulews);
    return (
      <div className="mask-content">
        <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect debug />
        <SideControl multiple={multiple} onItemClick={onItemClick} layerConfig={layerConfig} />
        <DataPane />
        <RulesLayer />
        <Explain visible={showExplain} onExplainClose={onExplainClose} />
      </div>
    );
  }
}

MaskContent.propTypes = {
  layerConfig: PropTypes.object,
  onItemClick: PropTypes.func,
  // 是否支持多选
  multiple: PropTypes.bool,
  subscribe: PropTypes.func,
  trigger: PropTypes.func,
  showExplain: PropTypes.bool,
  onExplainClose: PropTypes.func,
  hiddenScreenSaver: PropTypes.func,
  onTrigger: PropTypes.func
};

MaskContent.defaultProps = {
  multiple: false
};

export default MaskContent;
