import React, { Component } from 'react';
import PropTypes from 'prop-types';

class PaneItem extends Component {

  static propTypes = {
    data: PropTypes.object,
    onClick: PropTypes.func,
    renderItem: PropTypes.func
  };

  static defaultProps = {
    data: {},
    onClick(){}
  };

  constructor(props) {
    super(props);

  }


  render() {
    const { data, onClick, renderItem } = this.props;
    return (
      <div className="datapane-item">
        {
          (renderItem(data) || []).map(e => (
            <p key={e.name} className="datapane-prop" onClick={() => onClick(data)}>
              <span className="datapane-prop-name">{e.name}：</span>
              {
                e.render ? e.render(data) : <span className="datapane-prop-value">{data[e.value] || ''}</span>
              }
            </p>
          ))
        }
      </div>
    );
  }
}

export default PaneItem;
