import React, { Component } from 'react';
import { browserHistory } from 'amos-react-router';
import { Collapse, Scrollbars, Button } from 'amos-framework';
import UserSetting from './UserSetting';
import ShortcutKey from './ShortcutKey';

const Panel = Collapse.Panel;
/**
 * 设置
 * @class Setting
 * @extends {Component}
 */
class Setting extends Component {
  constructor(props) {
    super(props);
    this.state = {

    };
  }

  changeRegion = () => {
    browserHistory.push({
      pathname: '/region',
      state: 'changeRegion'
    });
  }

  render() {
    return (
      <div className="datapane-setting">
        <Scrollbars>
          <div className="datapane-setting-content">
            <Collapse className="datapane-setting-collapse" activeKey={['1', '2', '3']} onChange={key=>console.log(key)}>
              <Panel header="厂区选择" key="1">
                <Button className="region-select" onClick={this.changeRegion}>切换厂区</Button>
              </Panel>
              <Panel header="账户设置" key="2">
                <UserSetting />
              </Panel>
              <Panel header="快捷键" key="3">
                <ShortcutKey />
              </Panel>
            </Collapse>
          </div>
        </Scrollbars>
      </div>
    );
  }
}

export default Setting;
