import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Row, Col } from 'amos-framework';
import { euqipmentDetail3dAction } from '../../../../services/bizService';


const equipmentStatus = [
  { key: '01', label: '生产设备' },
  { key: '02', label: '应急设备' }
];

const getTypeName = (type)=>{
  return (equipmentStatus.find(e=>e.key === type) || {}).label;
};

const bodtCxt = [
  { name: '设备名称',key: 'name' },
  { name: '设备位号',key: 'code' },
  { name: '设备类别',key: 'type',render: getTypeName },
  { name: '所属工段',key: 'workshopSection' },
  { name: '部门/车间',key: 'leaderDepartmentName' },
  { name: '所在分区',key: 'regionDepartmentName' },
  { name: '责任人',key: 'leaderUserName' }
];

/**
 * 设备设施详情
 *
 * @class EquipDetailModal
 * @extends {Component}
 */
class EquipDetailModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      data: {}
    };
  }

  componentDidMount(){
    const { dialogId } = this.props;
    dialogId && this.queryEuqipmentDetail(dialogId);
  }

  queryEuqipmentDetail =(dialogId)=>{
    euqipmentDetail3dAction(dialogId).then(data =>{
      this.setState({ data });
    });
  }

  renderRow =(data)=>{
    return bodtCxt.map(item=>{
      return (<Row className="point-dialog-modal-row" key={item.key} >
        <Col className="colTitle">{item.name}：</Col>
        <Col className="colValue">{item.render ? item.render(data[item.key]) : data[item.key]}</Col>
      </Row>);
    });
  }

  render() {
    const { data } = this.state;
    return (
      <Row className="point-dialog-body">
        {this.renderRow(data)}
      </Row>
    );
  }
}

EquipDetailModal.propTypes = {
  dialogId: PropTypes.string,
  type: PropTypes.string
};

export default EquipDetailModal;
