import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Button } from 'amos-framework';
import { CONSTS } from 'CONSTS/storageConsts';
import AmosGridTable from './../../../bizview/common/tableComponent/table/AmosGridTable';
import { riskSoureDetail3dAction } from '../../../../services/bizService';

const checkListColumns = (self) => {
  return [
    {
      title: '危险因素名称',
      dataIndex: 'name',
      key: 'name',
      width: '40%'
    },{
      title: '责任人',
      dataIndex: 'type',
      key: 'type',
      width: '20%',
      render: (text, record) => {
        if (record && record !== null) {
          record.map((item, index) => {
            //根据换行符分隔
            let arr = item.type.split(",");
            let p = document.createElement('span');

            if (arr && arr !== null) {
              arr.map((e, index) => {
                if(index == 0){
                  let grandChildItem = document.createElement('p');
                  grandChildItem.innerText = "公司:";
                  let font = document.createElement('font');
                  font.innerText = e;
                  grandChildItem.append(font);
                  p.append(grandChildItem);
                }


              });
              return <div dangerouslySetInnerHTML={{ __html: p.outerHTML }} ></div>
            }
          })

        }


    }
    },{
      title: '风险等级',
      dataIndex: 'level',
      key: 'level',
      width: '20%'
    },{
      title: '安全管控状态',
      dataIndex: 'controlStatus',
      key: 'controlStatus',
      width: '20%'
    }
  ];
};


export const data =

  [
    {
      "id": 16,
      "name": "Y巡检点就是危险因素",
      "type": "公司11,部门,班组,岗位",
      "level": "4级",
      "controlStatus": null
    }
  ]



/**
 * 风险详情
 *
 * @class RiskSourceDetailModal
 * @extends {Component}
 */
class RiskSourceDetailModal extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selectedRows: [],
      selectedRowKeys: [],
      data: {}
    };
  }

  componentDidMount(){
    const { riskSourceId } = this.props;
    riskSourceId && this.queryRiskSoureDetail(riskSourceId);
  }

  onButtonClick =()=>{
    const { id: pointId } = this.state.data;
    const { tirggerTransTopic } = this.props;
    const detailParams = { type: 'risk',detailForw: 'record',dialogId: pointId };
    pointId && tirggerTransTopic && tirggerTransTopic(CONSTS.forward, { details: detailParams, dateTime: Date.now() });
  }

  queryRiskSoureDetail =(riskSourceId)=>{
    riskSoureDetail3dAction(riskSourceId).then(data =>{
      this.setState({ data });
    });
  }
  /**
   * 获取表格刷新方法
   */
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };

  renderDanger =(danger)=>{
    return (danger || []).map(item =>{
      return (<p key={item.id} >
        <span>{item.label} &nbsp;</span>
        <span>{item.content}：</span>
        <span style={{ color: '#FF0000' }}>管控措施失效</span>
      </p>);
    });
  }

  render() {
    //const { data = {} } = this.state;
    return (
      <div className="risk-warn">
        <div className="risk-source-header" >
          <div><span style={{ fontWeight: 'bold' }}>风险编号：</span>{data.code || ''}</div>
          <div><span style={{ fontWeight: 'bold' }}>风险名称：</span>{data.name || ''}</div>
          <div><span style={{ fontWeight: 'bold' }}>级别：</span>{data.riskLevel || ''}</div>
          <Button className="risk-warn-button" color="#EEEEEE" onClick={this.onButtonClick}>检查记录</Button>
        </div>
        <div className="risk-warn-table">
          <AmosGridTable
            columns={checkListColumns(this)}
            getTableDataAction={()=>{}}
            callBack={this.reload}
            isPageable={false}
            isChecked={false}
            dataList={data || []}
          />
        </div>

        <div className="risk-warn-content">
          <div className="risk-warn-content-header">隐患：</div>
          {data.riskFactorsControlMeasures && this.renderDanger(data.riskFactorsControlMeasures)}
        </div>
      </div>
    );
  }
}

RiskSourceDetailModal.propTypes = {
  riskSourceId: PropTypes.string,
  tirggerTransTopic: PropTypes.func
};


export default RiskSourceDetailModal;
