import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Markers } from 'amos-3d';
import PointDialog from './PointDialog';
import MarkerIcon from './MarkerIcon';

export default function markerFactory(WrappedComponent = 'div', options){
  const { markerType } = options;
  class MarkerPoints extends Component {

    static propTypes = {
      // marker 显隐
      visible: PropTypes.bool
    };

    constructor(props) {
      super(props);
      this.markerEvents = {
        click: this.onMarkerClick,
        dblclick: this.onMarkerDblClick
        // mouseover: (marker) => {
        //   marker.redraw(this.renderMarkerHover);
        // },
        // mouseout: (marker) => {
        //   marker.redraw(this.renderMarker);
        // }
      };
    }

    componentDidMount() {

    }

    onMarkerClick = (marker, e) => {
      clearTimeout(this.time);
      this.time = setTimeout(()=>this.pdRef.onOpenClick(marker), 500);
    }

    onMarkerDblClick = (marker, e) => {
      clearTimeout(this.time);
      this.pdRef.tirggerBussines(marker);
    }

    renderMarkerHover = (extData) => {
      return <MarkerIcon {...extData} markerType={markerType} />;
    }

    renderMarker = (extData) => {
      return <MarkerIcon {...extData} markerType={markerType} />;
    }

    render() {
      return (
        <WrappedComponent>
          <Markers
            {...this.props}
            events={this.markerEvents}
            render={this.renderMarker}
          />
          <PointDialog ref={node => this.pdRef = node} />
        </WrappedComponent>
      );
    }
  }

  return MarkerPoints;
}
