import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { patrolURI } from 'CONSTS/urlConsts';
import imgStatic from 'CONSTS/imgStatic';
import Carousel from './../../common/Carousel';

const transitionTime = 500;

class Picture extends Component {

  static propTypes = {
    markerData: PropTypes.object
  };

  static defaultProps = {
    markerData: {}
  };

  constructor(props) {
    super(props);
    this.state = {
      carouselVisable: false
    };
  }

  componentDidMount() {
    //Carousel组件中会计算容器宽度，然而此容器是通过css3过渡属性将宽度在0.5秒内慢慢放大，故目前等待0.5秒进行展示
    this.timer = setTimeout(() => {
      this.setState({ carouselVisable: true });
    }, transitionTime);
  }

  componentWillUnmount() {
    clearTimeout(this.timer);
  }

  render() {
    const { markerData } = this.props;
    let { photosUrl = [] } = markerData || {};
    let imgs = photosUrl.map(e => `${patrolURI}${e.substr(1,e.length - 1)}`);
    return (
      <div className="point-details-picture">
        { imgs.length > 0 && this.state.carouselVisable && <Carousel files={imgs} />}
        { imgs.length === 0 &&
          <div className="points-details-empty">
            <img src={imgStatic.datapane.smilingFace} alt="" />
            <p>暂无图片</p>
          </div>
        }
      </div>
    );
  }
}

export default Picture;
