import React, { Component } from 'react';
import PropTypes from 'prop-types';
import BizIcon from '../../common/icon/BizIcon';

class InnateControlItem extends Component {

  constructor(props) {
    super(props);
    this.state = {
      showLabel: false, // 是否显示提示
      position: { top: '', left: '' } // 提示相对鼠标坐标位置
    };
  }

  changeLabelState = (e, type) => {
    if (type === 'over') {// mouse over
      this.setState({ showLabel: true });
    } else if (type === 'out'){// mouse out
      this.setState({ showLabel: false });
    } else {// mouse move
      const x = 15;
      const y = 10;
      let top = e.nativeEvent.layerY + y + 'px';
      let left = e.nativeEvent.layerX + x + 'px';
      this.setState({
        position: {
          top,
          left
        }
      });
    }
  }

  render() {
    let { showLabel, position } = this.state;
    let { item, cls, onItemClick } = this.props;
    const { key, icon } = this.props.item;
    return (
      <div key={key} className={cls} onClick={() => onItemClick(item)} title={item.title} onMouseOver={(e) => this.changeLabelState(e, 'over')} onMouseOut={(e) => this.changeLabelState(e, 'out')} onMouseMove={(e) => this.changeLabelState(e, 'move')}>
        <BizIcon icon={icon} />
        <div className="marker-icon-title" style={{ visibility: showLabel ? 'inherit' : 'hidden', top: position.top, left: position.left }}>
          <div className="title-text">{item.label}</div>
        </div>
      </div>
    );
  }
}

InnateControlItem.propTypes = {
  // 具体的 innate control item
  item: PropTypes.object,
  position: PropTypes.objetct,
  showLabel: PropTypes.string,
  cls: PropTypes.string,
  onItemClick: PropTypes.func
};

export default InnateControlItem;
