import { transitionHelper } from 'amos-3d/lib/helpers';

const { BaseObjHelper } = transitionHelper;

export class OpacityAnimator {
  constructor(params = {}) {
    this.objs = [];
  }

  setWall(obj){
    this.wall = obj;
  }

  setFloor(obj){
    this.floor = obj;
  }

  add(obj){
    // obj helper
    const boh = new BaseObjHelper({ obj });
    obj._boh = boh;
    this.objs.push(obj);
  }

  doFade(boh, toOpacity){
    boh.fade({
      duration: 1000
    }, toOpacity);
  }

  toggleOpacity(flag){
    const me = this;
    this.objs.forEach(obj => {
      me.doFade(obj._boh, flag ? 0.3 : 1.0);
    });
  }

  set wallVisible(flag){
    this.wall.visible = flag;
  }

  set floorVisible(flag){
    this.floor.visible = flag;
  }
}