import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { connect3D, ParabolaCurve } from 'amos-3d/lib/designer';
import { WorkerMen3D } from './points';
import { curveConf } from './conf';

const Shuttle = (props) => props.children;

/**
 * Markers 池，所有的 markers 均在本类进行加载
 *
 * @export
 * @class PersonCurves
 * @extends {Component}
 */
@connect3D
class PersonCurves extends Component {

  constructor(props) {
    super(props);
  }

  componentWillMount = () => {
    this.setState({ alarmStarted: this.props.alarmStarted });
  }

  componentWillReceiveProps = nextProps => {
    this.setState({ alarmStarted: nextProps.alarmStarted });
  }

  /**
   * 点创建完成
   *
   * @memberof PersonCurves
   */
  onMarkersCreated = ({ markersCache }) => {
    this.workerMenMarker = markersCache;
    (markersCache || []).forEach(mc => {
      const extData = mc.getExtData();
      if ('visible' in extData){
        const visible = extData.visible;
        if (visible) {
          if (extData.type === 'workerMen') {
            mc.visible = visible;
            mc.object2DPipe.pipeNode.visible = false;
            mc.object2DPipe.pipeNode.elementVisible = false;
          } else {
            mc.show();
          }
        } else {
          if (extData.type === 'workerMen') {
            mc.visible = visible;
            mc.object2DPipe.pipeNode.visible = false;
            mc.object2DPipe.pipeNode.elementVisible = false;
          } else {
            mc.hide();
          }
        }
      }
    });
  }

  /**
   * 更新点数据
   *
   * @memberof PersonCurves
   */
  updateMarkers = (data) => {
    this.props.updateMarker(data);
  }

  render() {
    const { markers, curves = [], ...rest } = this.props;
    const { alarmStarted } = this.state;
    return (
      <Shuttle>
        {
          alarmStarted && <WorkerMen3D {...rest} markers={markers} onCreated={this.onMarkersCreated} />
        }
        {
          curves.map(c => <ParabolaCurve {...rest} key={c.key} points={c.points} onlyStartEnd circleDot pointProps={curveConf.parabola} />)
        }
      </Shuttle>
    );
  }
}

PersonCurves.propTypes = {
  subscribe: PropTypes.func,
  updateMarker: PropTypes.func,
  markers: PropTypes.array,
  curves: PropTypes.arrayOf(PropTypes.shape({
    key: PropTypes.string,
    points: PropTypes.array
  })),
  alarmStarted: PropTypes.bool
};

export default PersonCurves;
