/* eslint-disable react/no-array-index-key */
/* eslint-disable no-mixed-operators */
/* eslint-disable no-plusplus */
/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Carousel } from 'amos-framework';
import { connect3D } from 'amos-3d/lib/designer';
import classNames from 'classnames';

const eventConnect = Connect.eventConnect;

const alarmType = {
  impEquipment: 1,
  dynamicRingData: 2,
  patrol: 3,
  autoInspection: 5, //自动巡检设备
  fireDetection: 6, //自动巡检设备
};

/**
 * 三维告警面板
 *
 * @class MarkerPanel
 * @extends {Component}
 */
@connect3D
@eventConnect
class AlarmMarkerPanel extends Component {
  constructor(props) {
    super(props);
    this.state = {
      selected: false
    };
  }

  onClick = (type, item) => {
    // console.log(type, item);
    this.props.onAlarmClick(type, item);
  }

  /**
   * 分割数组创建二维数组
   *
   * @param data 数组
   * @param senArrLen 需要分割成子数组的长度
   * @memberof AlarmMarkerPanel
   */
  splitArray = (array, len) => {
    const length = array.length;
    if (!length || !len || len < 1) {
      return [];
    }
    let index = 0; //用来表示切割元素的范围start
    let resIndex = 0; //用来递增表示输出数组的下标

    //根据length和size算出输出数组的长度，并且创建它。
    let result = new Array(Math.ceil(length / len));
    while (index < length) {
      result[resIndex++] = array.slice(index, index += len);
    }

    return result;
  }

  /**
   * 渲染子集数据
   *
   * @memberof AlarmMarkerPanel
   */
  renderChild = (type, datas, len) => {
    const emptyCls = classNames('title-child-empty', {
      'title-child-empty-1': len === 1
    }, {
      'title-child-empty-2': len === 2
    }, {
      'title-child-empty-3': len === 3
    });

    return (
      datas.map((items, index) => {
        return (
          <div className="title-carousel" key={index}>
            {items.map(item => {
              if (item.content !== undefined) {
                const pointType = parseInt(item.pointType);
                let title = '';
                if(alarmType.patrol === pointType){
                  title = '检查异常'
                }else if(alarmType.dynamicRingData === pointType){
                  title = '动环告警'
                }else if(alarmType.impEquipment === pointType){
                  title = '设备告警'
                }else if(alarmType.autoInspection === pointType){
                  title = '虚拟设备'
                }else if(alarmType.fireDetection === pointType){
                  title = '火探告警'
                }
                return (
                  <div key={item.id} className="title-child">
                    <div className="title-front">{title}</div>
                    <div className="title-text" onClick={() => this.onClick(type, item)} title={item.content}>{item.content}</div>
                  </div>
                );
              } else {
                return (
                  <div key={item.id} className={emptyCls}>
                    <div className="title-front-empty" />
                    <div className="title-text-empty" />
                  </div>
                );
              }
            })}
          </div>
        );
      })
    );
  }

  /**
   * 渲染内容
   *
   * @memberof AlertMarkerPanel
   */
  renderContent = (type, data) => {
    if (!data) {
      return;
    }
    let datas = this.splitArray(data, 5);
    let len = 0;
    datas.forEach(arr => {
      for (let i = 0; arr.length < 5; i++) {
        len++;
        arr.push({});
      }
    });

    return (
      <div className="marker-panel-content">
        <div className="title-content">
          <Carousel vertical autoplay dots={false}>
            {this.renderChild(type, datas, len-1)}
          </Carousel>
        </div>
      </div>
    );
  };

  render() {
    const { data, type } = this.props;

    // 面板样式
    const panelCls = classNames('marker-alarm', {
      'alarm-floor-3': type === 'floor_3'
    }, {
      'alarm-floor-6': type === 'floor_6'
    }, {
      'alarm-floor-xy': type === 'floor_xy'
    });

    // 连接线样式
    const panelLineCls = classNames('marker-panel-line', {
      'line-floor-3': type === 'floor_3'
    }, {
      'line-floor-6': type === 'floor_6'
    }, {
      'line-floor-xy': type === 'floor_xy'
    });

    return (
      <div className={panelCls}>
        {this.renderContent(type, data)}
        <div className={panelLineCls} />
      </div>
    );
  }
}

AlarmMarkerPanel.propTypes = {
  type: PropTypes.string,
  data: PropTypes.array
};

export default AlarmMarkerPanel;
