import React, { Component } from 'react';
import { UUID } from 'amos-tool';
import message from 'amos-framework/lib/message';
import { utils } from 'amos-tool';

/**
 * 首页告警跑马灯
 *
 * @class AlarmMarquee
 * @extends {Component}
 */
class AlarmMarquee extends Component {
  constructor(props) {
    super(props);
    this.state = {
      message: []
    };
  }

  /**
   * 转换时间
   */
  transTime = (time) => {
    var now = new Date(time),
      y = now.getFullYear(),
      m = now.getMonth() + 1,
      d = now.getDate();
    return y + "-" + (m < 10 ? "0" + m : m) + "-" + (d < 10 ? "0" + d : d) + " " + now.toTimeString().substr(0, 8);
  }

  /**
   * 转换类型
   */
  transType = (v) => {
    const types = {
      1: '设备',
      2: '动环',
      3: '巡检',
      4: '通道',
      5: '虚拟设备',
      6: '火探'
    };
    return types[v];
  }

  /**
   * 重置消息
   */
  resetMessage = (message) => {
    if (!utils.isEmpty(message) && utils.isArray(message)) {
      return (<div>
        {
          message.map(e => {
            return <div key={e.id} className="amosicon tops-news-item base-small-fs">
              <span>告警类型:</span><span>{e.pointType ? this.transType(e.pointType) : ''}</span>&nbsp;&nbsp;
                            <span>告警内容:</span><span>{e.content || ''}</span>&nbsp;&nbsp;
                            <span>告警时间:</span><span>{e.updateDate ? this.transTime(e.updateDate) : ''}</span>&nbsp;&nbsp;
                        </div>
          })
        }
      </div>);
    }
  }

  onMouseOver = () => {
    document.getElementById('marquee').stop();
  };

  onMouseOut = () => {
    document.getElementById('marquee').start();
  }

  render() {
    const { pmdList } = this.props;
    return (
      <div className="AlarmMarquee-top-news">
        <div className="news-marquee">
          <marquee
            id="marquee"
            direction="left"
            behavior="scroll"
            scrollamount="10px"
            scrolldelay="120"
            loop="-1"
            width="auto"
            height="100"
            bgcolor="transparent"
            hspace="0"
            vspace="0"
            onMouseOver={() => { this.onMouseOver() }}
            onMouseOut={() => { this.onMouseOut() }}
          >
            {this.resetMessage(pmdList)}
          </marquee>
        </div>
      </div>
    );
  }
}

export default AlarmMarquee;
