import React from 'react';
import PropTypes from 'prop-types';
import { Icon } from 'amos-framework';

/**
 * FullScreen
 * @param {Object} props
 */
const FullScreen = props => {
  const { onFullScreen, isFullScreen } = props;
  return (
    <div className="common-full-screen" onClick={onFullScreen}>
      {!isFullScreen ? <Icon icon="arrowsalt" /> : <Icon icon="shrink" />}
    </div>
  );
};

FullScreen.propTypes = {
  isFullScreen: PropTypes.bool,
  onFullScreen: PropTypes.func
};

export default FullScreen;
