import React from 'react';
import PropTypes from 'prop-types';
import { Button ,Icon } from 'amos-framework';
import classnames from 'classnames';
import './FilterPane.scss';
/**
 * 公共列表页面-筛选面板容器
 *
 * @class FilterPane
 * @extends {Component}
 */
function FilterPane(props) {
  const { children, onSearch, show, className, style ,onReset } = props || {};
  return (
    <div className={classnames('eb-com-filter-pane', className)} style={{ display: show ? 'block' : 'none', ...style || {} }}>
      <div className='eb-com-filter-pane-title'>
        <span>筛选</span>
        <a className="qq-client-open" onClick={onReset} >
              <Icon size="1x"  prefix="amosicon" icon="gengduo2" />
        </a>
      </div>
      <div className='eb-com-filter-pane-content'>
        {children}
      </div>
      <div className='eb-com-filter-pane-footer'>
        {/* <Button className={classnames('eb-com-filter-pane-btn', 'eb-com-filter-pane-reset-btn')} onClick={onReset}>重置</Button> */}
        <Button className={classnames('eb-com-filter-pane-btn', 'eb-com-filter-pane-search-btn')} onClick={onSearch}>查询</Button>
      </div>
    </div>
  );
}


FilterPane.propTypes = {
  style: PropTypes.object,
  className: PropTypes.any,
  children: PropTypes.any,
  show: PropTypes.bool,
  onReset: PropTypes.func,
  onSearch: PropTypes.func,
  onHide: PropTypes.func,
  handleFilterShow: PropTypes.func
};

FilterPane.defaultProps = {
  onReset(){
    this.props.onSearch();
  },
  onSearch(){
    this.props.onSearch();
  }
};

export default FilterPane;
