/* eslint-disable no-magic-numbers */
import * as THREE from 'three';
import { TextureFactory, modelClassifyMapper } from 'amos-3d';
import { backgroundHelpers } from 'amos-3d/lib/helpers';
import { utils } from 'amos-tool';

const { getInnerSkybox } = backgroundHelpers;

/**
 * 天空背景颜色
 */
const customSkybox = backgroundHelpers.createBackground({
  basePath: '/threeres/bg/bluesky2/',
  names: ['pos_x.jpg', 'neg_x.jpg', 'pos_y.jpg', 'neg_y.jpg', 'pos_z.jpg', 'neg_z.jpg']
});

/**
 * 获取材料
 */
const getMaterial = () => {
  const groundTexture = TextureFactory.createTextureByUrl('/threeres/mesh/grid-gray.jpg', {
    wrapS: THREE.RepeatWrapping,
    wrapT: THREE.RepeatWrapping,
    anisotropy: 26
  });
  groundTexture.repeat.set(25, 25);
  const groundMaterial = new THREE.MeshLambertMaterial({ map: groundTexture });
  return groundMaterial;
};

/**
 * 从数组中组装具体的数据，返回 数组
 * @param {Array} arr
 * @param {string|array} props
 */
export const getPropFromArr = (arr, props) => {
  const result = [];
  arr.forEach(a => {
    if (utils.isArray(props)){
      const item = {};
      props.forEach(p => {
        if (a[p]){
          item[p] = a[p];
        }
      });
      if (!utils.isEmpty(item)){
        result.push(item);
      }
    } else {
      if (a[props]){
        result.push(a[props]);
      }
    }
  });
  return result;
};

/**
 * 视图控制
 */
export const viewController = [
  // { key: 'park-contorller', icon: 'shu-changqu', type: 'park', singleClick: true, label: '选择建筑' },
  // { key: 'burst-contorller', icon: 'zhalie', type: 'burst', singleClick: true, label: '炸裂' },
  { key: 'back-controller', icon: 'fanhui', type: 'back', singleClick: true, label: '返回' },
  { key: 'fitview-contorller', icon: 'zuijiashijiao', type: 'fitview', singleClick: true, label: '初始视图' },
  { key: 'explain-controller', icon: 'jianpan', type: 'explain', singleClick: true, label: '控件' },
  { key: 'pick-controller', icon: 'qudian', type: 'pick', singleClick: true, label: '坐标拾取' }
];

/**
 * 业务控制
 */
export const bizControls = [
  { key: 'riskSource-point', icon: 'fengxiandian', type: 'riskSource', label: '风险点', subs: [
    { key: 'level_1', label: '1级' },
    { key: 'level_2', label: '2级' },
    { key: 'level_3', label: '3级' },
    { key: 'level_4', label: '4级' }
  ] },
  { key: 'patrol-point',  icon: 'dianwei-zhongdianshebei', type: 'patrol', label: '巡检点', subs: [
    { key: 'level_3', label: '漏检' },
    { key: 'level_2', label: '不合格' },
    { key: 'level_1', label: '合格' },
    { key: 'level_0', label: '未计划' }
  ] },
  { key: 'impEquipment-point', icon: 'zhongdianshebeixiangqing', type: 'impEquipment', label: '设备点', subs: [
    { key: 'impEqu_01', label: '网络设备' },
    { key: 'impEqu_02', label: '服务器' },
    { key: 'impEqu_03', label: '虚拟设备' },
    { key: 'impEqu_04', label: 'IP设备' }
  ] },
  // { key: 'monitorEquipment-point', icon: 'shujudian', type: 'monitorEquipment', label: '动环数据' },
  { key: 'dynamicRingData-point', icon: 'shujudian', type: 'dynamicRingData', label: '动环数据' },
  { key: 'monitor-point', icon: 'xunjiandian', type: 'video', label: '视频监控' }
];

export const bizControlsTypes = [
  { key: 'riskSource', label: '风险点' },
  { key: 'patrol' , label: '巡检点' },
  { key: 'impEquipment', label: '重点设备' },
  { key: 'dynamicRingData', label: '动环数据' },
  { key: 'monitorEquipment', label: '数据点' },
  { key: 'video', label: '视频点' }
];

export const riskSourceLevel = [
    { key: '1', label: '1级' },
    { key: '2', label: '2级' },
    { key: '3', label: '3级' },
    { key: '4', label: '4级' }
];

export const riskSourceStatus = [
  { key: '3', label: '漏检' },
  { key: '2', label: '不合格' },
  { key: '1', label: '合格' },
  { key: '0', label: '未计划' }
];

export default {
  ratio: 100,
  complete: 100,
  sceneBg: customSkybox,
  skybox: getInnerSkybox('bluesky'),
  fog: {
    color: 0x89bffb,
    neer: 5000,
    far: 10000
  },
  dlight: {
    color: 0xffffff,
    intensity: 1.0
  },
  plight: {
    color: 0xffffff,
    intensity: 0.8
  },
  plugins: {
    OrbitControls: {
      enable: true,
      params: {
        maxPolarAngle: 1.5, // 上下翻转的最大角度 Math.PI
        minPolarAngle: 0.5, // 上下翻转的最小角度 默认 0
        minDistance: 10, // 最近距离，表现在放大
        maxDistance: 5000, // 最远距离，表现在缩小
        rotateSpeed: 0.5, // 旋转速度 1.0
        dampingFactor: 0.2, // 动态阻尼系数 就是鼠标拖拽旋转灵敏度，阻尼越小越灵敏 0.25
        enableZoom: true, // 是否允许缩放
        autoRotate: true, // 是否自动旋转
        autoRotateSpeed: 0.2, // 自动旋转速度
        enablePan: true // 是否开启右键拖拽
      }
    },
    CameraHelper: {
      enable: true
    }
  },
  camera: {
    fov: 45,
    near: 1,
    far: 10000
  },
  meshBg: {
    geometry: new THREE.PlaneBufferGeometry(20000, 20000),
    material: getMaterial(),
    position: { y: -30 },
    rotation: { x: -Math.PI / 2 }
  },
  // 展开距离
  spacing: 50,
  link: {
    selectColor: 0x008000,
    fatlineProps: {
      lineStyle: {
        color: 0xff0000,
        linewidth: 2
      }
    },
    normalLineProps: {
      type: 'Line',
      lineStyle: {
        color: 0xff0000,
        linewidth: 1
      }
    }
  },
  // marker 移动耗时
  moveDuration: 3000
};

export const desigerConf = {
  sceneOptions: {
    background: 0x253366,
    skyBox: customSkybox
  },
  cameraOptions: {
    fov: 45,
    near: 1,
    far: 5000,
    position: [-4894.25, 482.12, -225.55],
    // 是否启用拾取器
    enablePicker: true,
    builtInOrbit: {
      maxPolarAngle: Math.PI * 0.5,
      minPolarAngle: Math.PI * 0.3,
      minDistance: 1,
      maxDistance: 5000
    }
  },
  // 配置信息，支持灯光的配置
  options: {
    light: [
      { type: 'AmbientLight', options: { color: 0xffffff, intensity: 0.52 } },
      { type: 'DirectionalLight', options: { color: 0xffffff, intensity: 0.11 } }
    ],
    floorBoard: {
      visible: true,
      position: { y: -30 },
      showType: 'grid',
      size: 1500,
      divisions: 20,
      colorCenterLine: 0x838a94,
      colorGrid: 0xd3dbe8,
      gridOptions: {
        opacity: 0.2,
        transparent: true
      },
      widthSegments: 1,
      heightSegments: 1,
      boardColor: 0x626667,
      boardOptions: {

      }
    }
  }
};

export const curveConf = {
  parabola: {
    size: 5,
    color: 0xff1c1c
  }
};

export const desigerHelperConfig = {
  cameraEffect: {
    position: [606.93, 371.91, 887.09],
    target: [88.39, 89.64, -86.80]
  },
  xyCameraEffect: {
    position: [15.74, 127.01, 337.55],
    target: [-140.95, 36.28, 463.66]
  },
  xdjCameraEffect: {
    position: [-84.78, 145.81, -130.55],
    target: [-40.01, 30.66, 21.48]
  },
  thirdFloorCameraEffect: {
    position: [236.32, 221.40, -22.71],
    target: [270.89, 161.16, 72.52],
    duration: 1000
  },
  xyThirdFloorCameraEffect: {
    position: [-186.36, 94.40, 466.63],
    target: [-232.04, 57.27, 517.50],
    duration: 1000
  },
  floorSixCameraEffect: {
    position: [276.83, 206.93, -31.05],
    target: [278.98, 132.95, 70.75],
    duration: 1000
  },
  cabinetCameraEffect: {
    position: [356.63, 89.87, 148.39],
    target: [348.49, 89.87, 132.55],
    duration: 1200
  },
  objAnchor: {
    position: [0, 5, 0]
  }
};

export const shortcutKeys = [
  {
    category: '三维移动控制',
    keys: [
      { name: '上移', key: '↑', status: '正常' },
      { name: '下移', key: '↓', status: '正常' },
      { name: '左移', key: '←', status: '正常' },
      { name: '右移', key: '→', status: '正常' }
    ]
  }
];
