import React, { Component } from 'react';
import { initView3DAction } from 'SERVICES/3dService';

/**
 * markers 数据连接层
 * 将后端数据注入到具体的组件
 * @param {object} options
 */
export default function markersConnect(options = {}) {
  const { type } = options;
  return WrappedCompoenet => class ApiComs extends Component {

    constructor(props) {
      super(props);
      this.state = {
        dataSource: []
      };
    }

    componentDidMount() {
      initView3DAction(type).then(d => {
        this.setState({
          dataSource: d
        });
      });
    }

    render() {
      return <WrappedCompoenet {...this.props} dataSource={this.state.dataSource} />;
    }
  };
}
