import React from 'react';
import {
  msgAction
} from 'SERVICES/3dService';
import { Connect } from 'amos-framework';
import DataPaneBasic from '../common/DataPaneBasic';
import DataPaneContent from '../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from '../common/PaneItem';
import ListPaginate from '../common/ListPaginate';
import { eventTopics } from '../../consts';

const eventConnect = Connect.eventConnect;

/**
 * 消息
 * @class Msg
 * @extends {Component}
 */
@eventConnect
class Msg extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      searchName: 'title',
      data: [],
      filter: [],
      page: 0,
      pageSize: 10
    };
  }

  componentDidMount(){
    this.onSearch();
    this.props.subscribe(eventTopics.datapane_msg, (topic, data) => {
      console.log('datapane_msg****', data);
      this.onHandleMsg(data);
    });
  }
  /**
   * 点击监控中的一个
   */
  onClick = (item) => {

  }

  onHandleMsg = (data) => {
    this.onSearch();
  }

  onSearch = (page) => {
    const { filter, pageSize } = this.state;
    let searchParam = {};
    filter.map(item => {
      searchParam[item.name] = item.value;
    });
    msgAction(searchParam, page || 0, pageSize).then(d => {
      this.list && this.list.setData(d, this);
    });
  }

  renderItem = (item) => {
    return [
      { name: '标题', value: 'title' },
      { name: '类型', value: 'type' },
      { name: '时间', value: 'timeStr' },
      { name: '内容',
        value: 'content',
        render: text => {
          return item.content.slice(0,item.content.lastIndexOf('<'));
        }
      }
    ];
  }

  render() {
    const { searchName, data, pageSize } = this.state;
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        filter={Filter}
        searchName={searchName}
      >
        <ListPaginate
          ref={node => this.list = node}
          data={data}
          pageSize={pageSize}
          onChangePage={this.onSearch}
          renderItem={e => <PaneItem renderItem={this.renderItem} key={e.id} data={e} onClick={this.onClick} />}
        />
      </DataPaneContent>
    );
  }
}

export default Msg;
