import React from 'react';
import { Connect } from 'amos-framework';
import {
  searchAction
} from 'SERVICES/3dService';
import DataPaneBasic from '../common/DataPaneBasic';
import DataPaneContent from '../common/DataPaneContent';
import Filter from './Filter';
import PaneItem from '../common/PaneItem';
import SearchWelCome from './SearchWelCome';
import ListPaginate from '../common/ListPaginate';
import { eventTopics, operateTypes } from '../../consts';
import { updateViewData, update3DViewData } from '../../dataProcessor';
import { bizControlsTypes } from '../../conf';

const eventConnect = Connect.eventConnect;

/**
 * 检索
 * @class Search
 * @extends {DataPaneBasic}
 */
@eventConnect
class Search extends DataPaneBasic {
  constructor(props) {
    super(props);
    this.state = {
      searchName: 'type',
      data: [],
      filter: [],
      page: 0,
      pageSize: 10,
      isStart: true
    };
  }

  componentDidMount(){
    this.onSearch(0);
  }

  /**
   * 点击检索结果中的一个
   */
  onClick = (item) => {
    // 更新视图数据
    let views = new Array();
    views.push(item);
    let args = {
      target: views,
      operateType: operateTypes.POINT_SEARCH
    };
    update3DViewData(args);
  }

  onSearch = (page) => {
    const { filter, pageSize, isStart } = this.state;
    if (isStart) {
      this.setState({ isStart: false });
    }

    let inputText = '';
    let dataLevel = '';
    let orgCode = '';
    let nodeState = '';
    let type = '';
    let routeName = '';
    let protectObjName = '';


    ( filter || [] ).forEach((item, i) => {
      if (item.name === 'type') {
        type = item.value;
      } else if (item.name === 'dataLevel') {
        dataLevel = item.value;
      } else if (item.name === 'nodeState') {
        nodeState = item.value;
      } else if (item.name === 'inputText'){
        inputText = item.value;
      } else if (item.name === 'route'){
        routeName = item.value;
      }  else if (item.name === 'impEquipment'){
        protectObjName = item.value;
      }
    });
    searchAction(inputText, dataLevel, orgCode, nodeState, protectObjName, routeName, type, page || 0, pageSize).then(d => {
      // 填充列表数据
      this.listRef.setData(d, this);
    });
  }

  renderItem = (item) => {
    if ('riskSource' === item.type) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'label' },
        { name: '等级', value: 'level' },
        { name: '类别', value: 'typeName' }
      ];
    } else if ('risk' === item.type) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'label' },
        { name: '路线', value: 'routeName' },
        { name: '状态', value: 'title' },
        { name: '责任人', value: 'person' },
        { name: '类别', value: 'typeName' }
      ];
    }  else if ('monitorEquipment' === item.type) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'label' },
        { name: '监控对象', value: 'protectObjName' },
        { name: '类别', value: 'typeName' }
      ];
    }  else if ('video' === item.type) {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'label' },
        { name: '监控对象', value: 'protectObjName' },
        { name: '类别', value: 'typeName' }
      ];
    }   else {
      return [
        { name: '编号', value: 'code' },
        { name: '名称', value: 'label' },
        { name: '类别', value: 'typeName' }
      ];
    }
  }

  render() {
    const { searchName, data, pageSize, isStart, filter } = this.state;
    let type = '';

    ( filter || [] ).forEach((item, i) => {
      if (item.name === 'type') {
        type = item.value;
      }
    });
    return (
      <DataPaneContent
        onFilterChange={this.onFilterChange}
        filter={Filter}
        type={type}
        dataList={bizControlsTypes}
        searchType={'selectAndInput'}
        searchName={searchName}
      >
        {
          !isStart ?
            <ListPaginate
              ref={node => this.listRef = node}
              data={data}
              pageSize={pageSize}
              onChangePage={this.onSearch}
              renderItem={e => <PaneItem renderItem={this.renderItem} key={e.id} data={e} onClick={this.onClick} />}
            />
            : <SearchWelCome />
        }
      </DataPaneContent>
    );
  }
}

export default Search;
