import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { SingleQueryEnum } from 'amos-processor/lib/config/queryEnum';
import { Select } from 'amos-framework';
import { DatePicker } from 'amos-antd';

const Option = Select.Option;
/**
 * 检索-过滤栏
 *
 * @class Filter
 * @extends {Component}
 */
class Filter extends Component {

  static propTypes = {
    onFilterChange: PropTypes.func,
    personList: PropTypes.array
  };

  static defaultProps = {
    personList: []
  };

  constructor(props) {
    super(props);
    this.state = {

    };
  }


  render() {
    const { onFilterChange, personList } = this.props;
    return (
      <div className="datapane-filter-content">
        <Select
          className="datapane-filter-item datapane-filter-select"
          data={personList}
          renderOption={item => <Option className="datapane-select-option" value={item.id}>{item.name}</Option>}
          defaultOption={<Option className="datapane-select-option">人员</Option>}
          onChange={(e) => onFilterChange('userId', e, SingleQueryEnum.EQUAL)}
        />
        <DatePicker
          className="datapane-filter-item datapane-filter-date"
          placeholder="时间"
          format="YYYYMMDD"
          onChange={(e, s) => onFilterChange('checkDate', s, SingleQueryEnum.EQUAL)}
        />
      </div>
    );
  }
}

export default Filter;
