/* eslint-disable react/prop-types */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import Close from '../common/Close';
import Header from '../common/Header';

class MinInfo extends Component {
  render() {
    const { onClose, content, table, headers, onItemClick, activeKey, title } = this.props;
    return (
      <div className="dialog-body-min">
        <div className="body-min-header">
          <div className="common-title">{title}</div>
          <Close onClose={onClose} />
        </div>
        {/* <Header headers={headers} onItemClick={onItemClick} activeKey={activeKey} /> */}
        <div className="body-min-content">
          {content}
        </div>
        <div className="body-min-table">
          {table}
        </div>
      </div>
    );
  }
}

MinInfo.propTypes = {
  activeKey: PropTypes.string,
  onClose: PropTypes.func,
  content: PropTypes.node,
  headers: PropTypes.array,
  onItemClick: PropTypes.func,
  title: PropTypes.string
};

export default MinInfo;
