import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal, AmosAlert } from 'amos-framework';
import AmosWebSocket from 'amos-websocket';
import * as endConf from 'amos-processor/lib/config/endconf';
import PilotController from 'amos-viz/lib/board/PilotController';
import SysWsURL, { completeToken } from 'CONSTS/wsUrlConsts';
// import AmosGridTable from './../../../bizview/common/tableComponent/table/AmosGridTable';
import { Table } from 'amos-antd';
import AlarmLineChart from './rightPane/alarmLineChart';
import moment from 'moment';
import { BarCharts } from 'amos-core';
import { setPieOption, setLineOption } from './chartData';
import ReactEcharts from 'amos-viz/lib/echarts';
import { getLeftMetricDataAction, getLeftDangerDataAction } from './../../../../services/2dService';
import { getSevenDaysAlarms, getMobileShowDate } from './../../../../services/alarmService';
import { browserHistory } from 'amos-react-router';
import { utils } from 'amos-tool';


// import Three3dView from './View3D';
// import { eventTopics } from './consts';
// import IndexChart from './indexChart';
const chartStyle = {
  width: '100%', height: '100%'
};
const chartDatas = {
  dangerNums: {
    total: 0,
    sevenAlarm: {
      xAxis: [],
      urgent: [],
      important: [],
      secondary: [],
      warning: []
    },
    data: [
      {
        name: '一级风险',
        value: '0/0'
      }, {
        name: '二级风险',
        value: '0/0'
      }, {
        name: '三级风险',
        value: '0/0'
      }, {
        name: '四级风险',
        value: '0/0'
      }
    ]
  },
  alarmNums: {
    total: 223,
    data: [
      {
        name: '紧急',
        value: '0/0'
      }, {
        name: '重要',
        value: '0/0'
      }, {
        name: '次要',
        value: '0/0'
      }, {
        name: '警告',
        value: '0/0'
      }
    ]
  },
  equipmentData: [
    {
      name: '网络设备',
      num: 0,
      unit: '个',
      damageNum: 0,
      damageRate: '0%'
    }, {
      name: '服务器',
      num: 0,
      unit: '个',
      damageNum: 0,
      damageRate: '0%'
    }, {
      name: 'NPC节点',
      num: 0,
      unit: '个',
      damageNum: 0,
      damageRate: '0%'
    }
  ],
  rangeData: [
    {
      name: '中心机房',
      data: [
        {
          name: '供配电',
          normalNum: 11,
          damageNum: 4
        },
        {
          name: 'UPS',
          normalNum: 15,
          damageNum: 6
        }, {
          name: '精密空调',
          normalNum: 21,
          damageNum: 5
        }, {
          name: '其他',
          normalNum: 19,
          damageNum: 8
        }
      ]
    }, {
      name: '通信转接机房',
      data: [
        {
          name: '供配电',
          normalNum: 13,
          damageNum: 4
        },
        {
          name: 'UPS',
          normalNum: 17,
          damageNum: 5
        }, {
          name: '精密空调',
          normalNum: 15,
          damageNum: 7
        }, {
          name: '其他',
          normalNum: 19,
          damageNum: 8
        }
      ]
    }
  ]
}
const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;
const enableScreenSaver = AmosConfig.screenSaverConf.enable;
const delayTime = AmosConfig.screenSaverConf.delayTime;


@eventConnect
class LeftCharts extends Component {
  constructor(props) {
    super(props);

    this.state = {
      currentCode: this.props.currentCode || '1*2',
      dangerNumData: [],
      gjdate: [],
      gjznum: 0,
      equipmentData: [],
      dangerAllNum: [0, 0],
      mobileDate: {
        QSZX: [],
        SBJ: [],
        HB: [],
        XFJC: [],
        LSJC: []
      }
    };

  }

  componentDidMount() {
    this.initData();
  }

  handleData = (data) => {
    console.log('WS风险总数刷新...');
    setTimeout(() => {
      this.initData();
    }, 2000);
  };

  componentWillReceiveProps = nextProps => {
    if (nextProps.currentCode && this.state.currentCode !== nextProps.currentCode) {
      const { currentCode } = nextProps || {};
      this.state.currentCode = currentCode;
      this.setState({ currentCode });
      this.initData();
    }
  };
  initData = () => {
    getLeftMetricDataAction({ code: this.state.currentCode }).then(data => {

      let dataList = data.data || [];
      let num = 0;
      dataList.forEach(v => {
        num = num + Number(v.value.split('/')[1]);
      });
      this.state.dangerAllNum[0] = num || 0;
      this.props.dotTipNumChange(this.state.dangerAllNum[0] + this.state.dangerAllNum[1]);
      this.setState({
        dangerNumData: data,
        dangerAllNum: this.state.dangerAllNum
      });
      if (data.result === 'FAILURE' && data.message) { AmosAlert.error('警告', data.message); }
    });

    let dates = {
      collectionName: 'alarm',
      conditions: [
        {
          name: 'orgCode',
          queryType: 'is',
          value: this.state.currentCode
        }
      ],
      groupBy: 'alarmLevel',
      statisticType: 'count'
    };

    getLeftDangerDataAction({ code: this.state.currentCode }).then(data => {


      if (data && data.length > 0) {
        let num = 0;
        data.forEach(v => {
          num = num + v.value;
        });
        this.state.dangerAllNum[1] = num || 0;
        this.props.dotTipNumChange(this.state.dangerAllNum[0] + this.state.dangerAllNum[1]);
        this.setState({
          gjznum: num,
          dangerAllNum: this.state.dangerAllNum
        });
      }

      this.setState({
        gjdate: data
      });
    });
    // 设备图
    // getLeftMetricDataAction2(this.state.currentCode).then(data => {
    //   // console.log('llllll',data);
    //   this.setState({
    //     equipmentData: data
    //   });
    // });

    getSevenDaysAlarms().then(d => {
      this.setState({ sevenAlarm: d });
    });
    getMobileShowDate().then(d => {
      this.setState({ mobileDate: d });
    });
  }


  gofx() {
    browserHistory.push('/biz/riskModel');
  }

  componentWillUnmount() {

  }
  renderDangerNum = () => {
    let { dangerNumData } = this.state;
    return (dangerNumData.data || chartDatas.dangerNums.data || []).map((item, index) => {
      return (
        <div className='item' key={index} onClick={() => { this.gofx() }}>
          <div className='itemContent'   >
            <span className='itemValue'>{item.value}</span>
            <span className='itemLable'>{item.name}</span>
          </div>

        </div>
      )
    })
  }
  renderAlarmNum = () => {
    // let alarmNumData = chartDatas.alarmNums.data || [];
    // return alarmNumData.map(item => {
    //   return (
    //     <div className='item'>
    //       <span className='itemValue'>{item.value}</span>
    //       <span className='itemLable'>{item.name}</span>
    //     </div>
    //   )
    // })
    let { gjdate } = this.state;
    // gjdate = gjdate.filter( e => { return e._id != null })

    if (!utils.isEmpty(gjdate) && utils.isArray(gjdate)) {
      return (gjdate || []).map((item, index) => {
        return (
          <div className='item' key={index}>
            <div className='itemContent'>
              <span className='itemValue'>{item.value}</span>
              <span className='itemLable'>{item.name}</span>
            </div>

          </div>
        )
      })
    } else {
      let alarmNumData = chartDatas.alarmNums.data || [];
      return alarmNumData.map((item, index) => {
        return (
          <div className='item' key={index}>
            <div className='itemContent'>
              <span className='itemValue'>{item.value}</span>
              <span className='itemLable'>{item.name}</span>
            </div>

          </div>
        )
      })
    }
  }
  renderEquipmentData = () => {
    let { mobileDate } = this.state;
    console.log('mobileDate' + mobileDate.QSZX);
    let wd1 = mobileDate.QSZX.find(item => item.text === '1#温湿度') || {};
    let wd2 = mobileDate.QSZX.find(item => item.text === '2#温湿度') || {};
    let wd3 = mobileDate.SBJ.find(item => item.text === '3#温湿度') || {};
    let wd4 = mobileDate.SBJ.find(item => item.text === '4#温湿度') || {};
    let wd5 = mobileDate.HB.find(item => item.text === '1温湿度') || {};
    let wd6 = mobileDate.HB.find(item => item.text === '5温湿度') || {};
    let xaxf = mobileDate.XFJC.find(item => item.area === '西安') || {};
    let xyxf = mobileDate.XFJC.find(item => item.area === '咸阳') || {};
    let xals = mobileDate.LSJC.find(item => item.area === '西安') || {};
    let xyls = mobileDate.LSJC.find(item => item.area === '咸阳') || {};
    return (
      <div className="equipmentdiv">
        <AmosWebSocket ref={node => (this.aws = node)} url={SysWsURL.dyTopoURI} onMessage={this.handleData} reconnect debug />
        <div className="quarter-div top-left">
          <div className="dh-title">清算中心机房</div>
          <div className='dh-content'>
            <div className="dh-icon">
              <img src="/src/assets/indexChart/temperature.png" alt='' className="dh-img" />
            </div>
            <div className="dh-values" >
              <div className="dh-values-item">3#温度：{wd3.value === undefined ? '0°C' : wd3.value } </div>
              <div className="dh-values-item">4#温度：{wd4.value === undefined ? '0°C' : wd4.value }</div>
            </div>
          </div>
        </div>
        <div className="quarter-div top-right">
          <div className="dh-title">设备间</div>
          <div className='dh-content'>
            <div className="dh-icon">
              <img src="/src/assets/indexChart/temperature.png" alt='' className="dh-img" />
            </div>
            <div className="dh-values" >
              <div className="dh-values-item">1#温度：{wd1.value === undefined ? '0°C' : wd1.value } </div>
              <div className="dh-values-item">2#温度：{wd1.value === undefined ? '0°C' : wd2.value }  </div>
            </div>
          </div>
        </div>
        <div className="quarter-div down-left">
          <div className="dh-title">货币发行机房</div>
          <div className='dh-content'>
            <div className="dh-icon">
              <img src="/src/assets/indexChart/temperature.png" alt='' className="dh-img" />
            </div>
            <div className="dh-values" >
              <div className="dh-values-item">1温度：{wd5.value === undefined ? '0°C' : wd5.value }  </div>
              <div className="dh-values-item">5温度：{wd6.value === undefined ? '0°C' : wd6.value }  </div>
            </div>
          </div>
        </div>
        <div className="quarter-div">
          <div className="xf-title">消防监测</div>
          <div className="xf-values" >
            <span className="xf-citys">西安：</span><span className={xaxf.value === '正常' ? 'xf-city-values' : 'xf-yc-values'}>{xaxf.value}</span>
            <span className="xf-citys">咸阳：</span><span className={xyxf.value === '正常' ? 'xf-city-values' : 'xf-yc-values'}>{xyxf.value}</span>
          </div>
          <div className="xf-title">漏水监测</div>
          <div className="xf-values" >
            <span className="xf-citys">西安：</span><span className={xals.value === '正常' ? 'xf-city-values' : 'xf-yc-values'}>{xals.value}</span>
            <span className="xf-citys">咸阳：</span><span className={xyls.value === '正常' ? 'xf-city-values' : 'xf-yc-values'}>{xyls.value}</span>
          </div>
        </div>
      </div>
    );
  };


  // renderRangeData = () => {
  //   let rangeData = chartDatas.rangeData || [];

  //   return rangeData.map((item, index) => {
  //     return (
  //       <div className='item' key={index}>
  //         <div className='chartDesc'>
  //           <span className='itemName'>{item.name}</span>
  //         </div>
  //         <div className='chartBox'>
  //           <ReactEcharts option={setLineOption(item)} style={chartStyle} className="react_for_echarts" />
  //         </div>
  //       </div>
  //     );
  //   });
  // }
  renderWorkList = () => {
    // let workMsg = chartDatas.workMsg || [];

  }
  reload = r => {
    this.setState(
      {
        reload: () => {
          r();
          this.setState({ selectedRows: [], selectedRowKeys: [] });
        }
      },
      r()
    );
  };


  render() {
    let now = moment().locale('zh-cn').format('YYYY-MM-DD');
    const { dangerNumData, gjdate, gjznum, sevenAlarm } = this.state;
    const wsURL = completeToken(SysWsURL.view3dws);
    return (
      <div className="chart-content">
        <AmosWebSocket ref={node => this.aws = node} url={wsURL} onMessage={this.handleData} reconnect />

        <div className='dangerNums'>
          <div className='tieleBox'>
            <div className='title'>
              <span className='titleLeft'>
                <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
              风险总数</span>
              <span className='titleRight'>{dangerNumData.total || 0}</span>
            </div>
          </div>
          <div className='chartBody'>
            {this.renderDangerNum()}
          </div>
        </div>
        <div className='alarmNums'>
          <div className='tieleBox'>
            <div className='title'>
              <span className='titleLeft'>
                <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
              告警统计</span>
              <span className='titleRight'>{gjznum || 0}</span>
            </div>
          </div>
          <div className='chartBody'>
            {this.renderAlarmNum()}
          </div>
        </div>
        <div className='equipmentdata'>
          <div className='tieleBox'>
            <div className='title'>
              <span className='titleLeft'>
                <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
                动环监控</span>
            </div>
          </div>
          <div className='chartBody'>
            {this.renderEquipmentData()}
          </div>
        </div>
        {/* <div className='rangeData'>
          <div className='tieleBox'>
            <div className='title'>
              <span className='titleLeft'>
                <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
              动环监控</span>
            </div>
          </div>
          <div className='chartBody'>
            {this.renderRangeData()}
          </div>
        </div> */}
        <div className='point'>
          <div className='title'>
            <span className='titleLeft'>
              <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }} />
                告警趋势统计</span>
          </div>
          <div className='chartBody'>
            <AlarmLineChart data={sevenAlarm} />
          </div>
        </div>
      </div>
    );
  }
}

LeftCharts.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default LeftCharts;
