import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import * as endConf from 'amos-processor/lib/config/endconf';
import { Row, Col } from 'amos-framework';
import { middleTabletAction, middleHeaderAction } from '../../../../../services/3dService';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;

const imgs = {"二线技术":"/src/assets/indexChart/work.png",
              "二线业务":"/src/assets/indexChart/service.png"}

// const time = {'早班': '08:30-20:30',
//               '晚班': '20:30-次日08:30'}

@eventConnect
class MiddleTable extends Component {
  constructor(props) {
    super(props);
    this.pageConfig = {
      current: 1,
      pageSize: 3
    };
    this.state = {
      headerData: {},
      dataList: [],
      arrangeList: [],
      arrangeName: null,
      arrangeNo: '',
      id: ''
    };
  }

  componentDidMount() {
    this.refreshDataList();
    this.getHeaderData();
  }
  getarrangeIdex = () =>{
    const { arrangeList, arrangeNo } = this.state;
    let count = 0;
    for (let i = 0; i < arrangeList.length; i++){
      if (arrangeList[i].id === arrangeNo){
        return count;
      } else {
        count = count + 1;
      }
    }
  }
  getHeaderData = () => {
    middleHeaderAction().then(data => {
      if(data!=null){
        this.setState({ headerData: data })
      }
    });
  }

  leftClick = () =>{
    const { arrangeList } = this.state;
    let count = this.getarrangeIdex();
    if (count - 1 < 0 ){
      return;
    } else {
      count =  count - 1;
    }
    middleTabletAction(arrangeList[count].id).then(data => {
      this.setState({ dataList: data.content, arrangeName: data.arrangeName,arrangeList: data.arrangeList,arrangeNo: data.arrangeNo });
    });
  }

  rightClick= ()=>{
    const { arrangeList } = this.state;
    let count = this.getarrangeIdex();
    if (count + 1 > arrangeList.length - 1){
      return;
    } else {
      count =  count + 1;
    }
    middleTabletAction(arrangeList[count].id).then(data => {
      this.setState({dataList: data.content, arrangeName: data.arrangeName,arrangeList: data.arrangeList,arrangeNo: data.arrangeNo  });
    });
  }

  refreshDataList = () => {
    middleTabletAction(this.state.id).then(data => {
      console.log(data);
      this.setState({ dataList: data.content, arrangeName: data.arrangeName,arrangeList: data.arrangeList,arrangeNo: data.arrangeNo });
    });
  }
  render() {
    const { headerData, dataList,arrangeList, arrangeNo } = this.state;
    let leader = (headerData.leader && headerData.leader[0]) || {};
    let secondTier = headerData.secondTier || [];
    let arrange = (arrangeList && arrangeList.find(item => item.id === arrangeNo)) || {};
    return (
        <div className='table-middle'>
          <div className='leaderBox'>
            <div className='leader'>
              <span className='itemLabel'>带班领导</span>
              <span className='itemValue'>{leader.dutyName || ''}</span>
              <span className='itemValue'>{ leader.mobile || ''}</span>
            </div>
            <div className='secondLine'>
              <span className='itemLabel'>二线人员</span>
              <div className='itemList'>
                { secondTier && secondTier.map(e => {
                  let postName = e.postName.replace('二线', '') + '岗';
                  return (
                    <div>
                      <img className='itemIcon' src={imgs[e.postName]} /> <div  className='itemContent' style={{color:'#05ddf9'}}>{postName}</div>
                      <div className='itemContent' >{e.dutyName}</div>
                      <div className='itemContent'> { e.mobile }</div>
                    </div>);
                }) }
              </div>
            </div>
          </div>
          <Row className='table-header-split'>一线人员</Row>
          <Row className='table-body-cotent firstPeople'>
            <Col className=''>
              <Row className='table-header-row duty-title'>
                <Col className='leftBtn' span={1}><img className='table-page-img' src="/src/assets/3dview/left.png" onClick={ () => this.leftClick() }/></Col>
                <Col span={5}>岗位</Col>
                <Col span={11}>{arrange.startTime} - {arrange.endTime} </Col>
                <Col span={6}>电话</Col>
                <Col className='rightBtn' span={1}><img className='table-page-img' src="/src/assets/3dview/right.png" onClick={ () => this.rightClick() }/></Col>
              </Row>
              { dataList && dataList.map((d,index) => {
                return (
                  <Row className='table-header-row content' key={index}>
                    <Col span={6}>{ d.postName }</Col>
                    <Col span={8}>{ d.dutyName }</Col>
                    <Col span={10}>{ d.mobile }</Col>
                  </Row>
                )
              }) }

            </Col>

          </Row>
        </div>
    );

  }
}

MiddleTable.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default MiddleTable;
