import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { Connect, Modal } from 'amos-framework';
import * as endConf from 'amos-processor/lib/config/endconf';
import ReactEcharts from 'amos-viz/lib/echarts';
import moment from 'moment';

import TopChart from './rightChartChild/topChart';
import MiddleTable from './rightChartChild/middleTable';
import BottomTable from './rightChartChild/bottomTable';

const eventConnect = Connect.eventConnect;
const AmosConfig = endConf.AmosConfig;

@eventConnect
class RightCharts extends Component {
  constructor(props) {
    super(props);
    this.state = {
    };
  }

  componentDidMount() { }

  componentWillUnmount() {
  }

  render() {
    //const { chartsViewFlag } = this.props;
    let now = moment().locale('zh-cn').format('YYYY-MM-DD');
    //console.log(this.props);
    let chartsViewFlag = 'patrolMsg';//还原版本
    //console.log('patrolMsg' === chartsViewFlag);
    return (
      <div className="chart-content">
        {
          chartsViewFlag === 'patrolMsg' ? <div className='patrolMsg'>
            <div className='point'>
              <div className='title'>
                <span className='titleLeft'>
                  <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
                  今日巡检计划执行情况</span>
                <span className='titleRight'>{now}</span>
              </div>
              <div className='chartBody'>
                <TopChart curCompanyId={this.props.currentCode} currentCode={this.props.currentCode} patrolDetailView={this.props.patrolDetailView} />
              </div>
            </div>
            <div className='technology'>
              <div className='title'>
                <span className='titleLeft'>
                  <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
                  值班信息</span>
                <span className='titleRight'>{now}</span>
              </div>
              <div className='chartBody'>
                <MiddleTable />
              </div>
            </div>
          </div> : ''
        }

        {
          chartsViewFlag === 'applyMsg' ? <div className='business'>
            <div className='title'>
              <span className='titleLeft'>
                <span className='titleIcon' style={{ background: 'url("/src/assets/indexChart/point.png") no-repeat center center/100% 100%' }}></span>
                支付业务累计数据</span>
              <span className='titleRight'>{now}</span>
            </div>
            <div className='chartBody'>
              <BottomTable orgCode={this.props.currentCode} />
            </div>
          </div> : ''
        }
      </div>
    );
  }
}

RightCharts.propTypes = {
  subscribe: PropTypes.func,
  trigger: PropTypes.func
};

export default RightCharts;
